// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
 */
@Fluent
public final class DedicatedHostGroupPropertiesAdditionalCapabilities
    implements JsonSerializable<DedicatedHostGroupPropertiesAdditionalCapabilities> {
    /*
     * The flag that enables or disables a capability to have UltraSSD Enabled Virtual Machines on Dedicated Hosts of
     * the Dedicated Host Group. For the Virtual Machines to be UltraSSD Enabled, UltraSSDEnabled flag for the resource
     * needs to be set true as well. The value is defaulted to 'false' when not provided. Please refer to
     * https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details on Ultra SSD
     * feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups that are created as zonal.
     * Minimum api-version: 2022-03-01.
     */
    private Boolean ultraSsdEnabled;

    /**
     * Creates an instance of DedicatedHostGroupPropertiesAdditionalCapabilities class.
     */
    public DedicatedHostGroupPropertiesAdditionalCapabilities() {
    }

    /**
     * Get the ultraSsdEnabled property: The flag that enables or disables a capability to have UltraSSD Enabled Virtual
     * Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual Machines to be UltraSSD Enabled,
     * UltraSSDEnabled flag for the resource needs to be set true as well. The value is defaulted to 'false' when not
     * provided. Please refer to https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more
     * details on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups that are
     * created as zonal. Minimum api-version: 2022-03-01.
     * 
     * @return the ultraSsdEnabled value.
     */
    public Boolean ultraSsdEnabled() {
        return this.ultraSsdEnabled;
    }

    /**
     * Set the ultraSsdEnabled property: The flag that enables or disables a capability to have UltraSSD Enabled Virtual
     * Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual Machines to be UltraSSD Enabled,
     * UltraSSDEnabled flag for the resource needs to be set true as well. The value is defaulted to 'false' when not
     * provided. Please refer to https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more
     * details on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups that are
     * created as zonal. Minimum api-version: 2022-03-01.
     * 
     * @param ultraSsdEnabled the ultraSsdEnabled value to set.
     * @return the DedicatedHostGroupPropertiesAdditionalCapabilities object itself.
     */
    public DedicatedHostGroupPropertiesAdditionalCapabilities withUltraSsdEnabled(Boolean ultraSsdEnabled) {
        this.ultraSsdEnabled = ultraSsdEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("ultraSSDEnabled", this.ultraSsdEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostGroupPropertiesAdditionalCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostGroupPropertiesAdditionalCapabilities if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DedicatedHostGroupPropertiesAdditionalCapabilities.
     */
    public static DedicatedHostGroupPropertiesAdditionalCapabilities fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostGroupPropertiesAdditionalCapabilities deserializedDedicatedHostGroupPropertiesAdditionalCapabilities
                = new DedicatedHostGroupPropertiesAdditionalCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ultraSSDEnabled".equals(fieldName)) {
                    deserializedDedicatedHostGroupPropertiesAdditionalCapabilities.ultraSsdEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostGroupPropertiesAdditionalCapabilities;
        });
    }
}
