// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Information of community gallery if current gallery is shared to community.
 */
@Fluent
public final class CommunityGalleryInfo implements JsonSerializable<CommunityGalleryInfo> {
    /*
     * The link to the publisher website. Visible to all users.
     */
    private String publisherUri;

    /*
     * Community gallery publisher support email. The email address of the publisher. Visible to all users.
     */
    private String publisherContact;

    /*
     * End-user license agreement for community gallery image.
     */
    private String eula;

    /*
     * The prefix of the gallery name that will be displayed publicly. Visible to all users.
     */
    private String publicNamePrefix;

    /*
     * Contains info about whether community gallery sharing is enabled.
     */
    private Boolean communityGalleryEnabled;

    /*
     * Community gallery public name list.
     */
    private List<String> publicNames;

    /**
     * Creates an instance of CommunityGalleryInfo class.
     */
    public CommunityGalleryInfo() {
    }

    /**
     * Get the publisherUri property: The link to the publisher website. Visible to all users.
     * 
     * @return the publisherUri value.
     */
    public String publisherUri() {
        return this.publisherUri;
    }

    /**
     * Set the publisherUri property: The link to the publisher website. Visible to all users.
     * 
     * @param publisherUri the publisherUri value to set.
     * @return the CommunityGalleryInfo object itself.
     */
    public CommunityGalleryInfo withPublisherUri(String publisherUri) {
        this.publisherUri = publisherUri;
        return this;
    }

    /**
     * Get the publisherContact property: Community gallery publisher support email. The email address of the publisher.
     * Visible to all users.
     * 
     * @return the publisherContact value.
     */
    public String publisherContact() {
        return this.publisherContact;
    }

    /**
     * Set the publisherContact property: Community gallery publisher support email. The email address of the publisher.
     * Visible to all users.
     * 
     * @param publisherContact the publisherContact value to set.
     * @return the CommunityGalleryInfo object itself.
     */
    public CommunityGalleryInfo withPublisherContact(String publisherContact) {
        this.publisherContact = publisherContact;
        return this;
    }

    /**
     * Get the eula property: End-user license agreement for community gallery image.
     * 
     * @return the eula value.
     */
    public String eula() {
        return this.eula;
    }

    /**
     * Set the eula property: End-user license agreement for community gallery image.
     * 
     * @param eula the eula value to set.
     * @return the CommunityGalleryInfo object itself.
     */
    public CommunityGalleryInfo withEula(String eula) {
        this.eula = eula;
        return this;
    }

    /**
     * Get the publicNamePrefix property: The prefix of the gallery name that will be displayed publicly. Visible to all
     * users.
     * 
     * @return the publicNamePrefix value.
     */
    public String publicNamePrefix() {
        return this.publicNamePrefix;
    }

    /**
     * Set the publicNamePrefix property: The prefix of the gallery name that will be displayed publicly. Visible to all
     * users.
     * 
     * @param publicNamePrefix the publicNamePrefix value to set.
     * @return the CommunityGalleryInfo object itself.
     */
    public CommunityGalleryInfo withPublicNamePrefix(String publicNamePrefix) {
        this.publicNamePrefix = publicNamePrefix;
        return this;
    }

    /**
     * Get the communityGalleryEnabled property: Contains info about whether community gallery sharing is enabled.
     * 
     * @return the communityGalleryEnabled value.
     */
    public Boolean communityGalleryEnabled() {
        return this.communityGalleryEnabled;
    }

    /**
     * Get the publicNames property: Community gallery public name list.
     * 
     * @return the publicNames value.
     */
    public List<String> publicNames() {
        return this.publicNames;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publisherUri", this.publisherUri);
        jsonWriter.writeStringField("publisherContact", this.publisherContact);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeStringField("publicNamePrefix", this.publicNamePrefix);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CommunityGalleryInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CommunityGalleryInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CommunityGalleryInfo.
     */
    public static CommunityGalleryInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CommunityGalleryInfo deserializedCommunityGalleryInfo = new CommunityGalleryInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publisherUri".equals(fieldName)) {
                    deserializedCommunityGalleryInfo.publisherUri = reader.getString();
                } else if ("publisherContact".equals(fieldName)) {
                    deserializedCommunityGalleryInfo.publisherContact = reader.getString();
                } else if ("eula".equals(fieldName)) {
                    deserializedCommunityGalleryInfo.eula = reader.getString();
                } else if ("publicNamePrefix".equals(fieldName)) {
                    deserializedCommunityGalleryInfo.publicNamePrefix = reader.getString();
                } else if ("communityGalleryEnabled".equals(fieldName)) {
                    deserializedCommunityGalleryInfo.communityGalleryEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("publicNames".equals(fieldName)) {
                    List<String> publicNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedCommunityGalleryInfo.publicNames = publicNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCommunityGalleryInfo;
        });
    }
}
