// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.CapacityReservationGroupProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Specifies information about the capacity reservation group. Only tags can be updated.
 */
@Fluent
public final class CapacityReservationGroupUpdate extends UpdateResource {
    /*
     * capacity reservation group Properties.
     */
    private CapacityReservationGroupProperties innerProperties;

    /**
     * Creates an instance of CapacityReservationGroupUpdate class.
     */
    public CapacityReservationGroupUpdate() {
    }

    /**
     * Get the innerProperties property: capacity reservation group Properties.
     * 
     * @return the innerProperties value.
     */
    private CapacityReservationGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CapacityReservationGroupUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the capacityReservations property: A list of all capacity reservation resource ids that belong to capacity
     * reservation group.
     * 
     * @return the capacityReservations value.
     */
    public List<SubResourceReadOnly> capacityReservations() {
        return this.innerProperties() == null ? null : this.innerProperties().capacityReservations();
    }

    /**
     * Get the virtualMachinesAssociated property: A list of references to all virtual machines associated to the
     * capacity reservation group.
     * 
     * @return the virtualMachinesAssociated value.
     */
    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociated();
    }

    /**
     * Get the instanceView property: The capacity reservation group instance view which has the list of instance views
     * for all the capacity reservations that belong to the capacity reservation group.
     * 
     * @return the instanceView value.
     */
    public CapacityReservationGroupInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    /**
     * Get the sharingProfile property: Specifies the settings to enable sharing across subscriptions for the capacity
     * reservation group resource. The capacity reservation group resource can generally be shared across subscriptions
     * belonging to a single Azure AAD tenant or across AAD tenants if there is a trust relationship established between
     * the tenants. Block capacity reservation does not support sharing across subscriptions. **Note:** Minimum
     * api-version: 2023-09-01. Please refer to https://aka.ms/computereservationsharing for more details.
     * 
     * @return the sharingProfile value.
     */
    public ResourceSharingProfile sharingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().sharingProfile();
    }

    /**
     * Set the sharingProfile property: Specifies the settings to enable sharing across subscriptions for the capacity
     * reservation group resource. The capacity reservation group resource can generally be shared across subscriptions
     * belonging to a single Azure AAD tenant or across AAD tenants if there is a trust relationship established between
     * the tenants. Block capacity reservation does not support sharing across subscriptions. **Note:** Minimum
     * api-version: 2023-09-01. Please refer to https://aka.ms/computereservationsharing for more details.
     * 
     * @param sharingProfile the sharingProfile value to set.
     * @return the CapacityReservationGroupUpdate object itself.
     */
    public CapacityReservationGroupUpdate withSharingProfile(ResourceSharingProfile sharingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CapacityReservationGroupProperties();
        }
        this.innerProperties().withSharingProfile(sharingProfile);
        return this;
    }

    /**
     * Get the reservationType property: Indicates the type of capacity reservation. Allowed values are 'Block' for
     * block capacity reservations and 'Targeted' for reservations that enable a VM to consume a specific capacity
     * reservation when a capacity reservation group is provided. The reservation type is immutable and cannot be
     * changed after it is assigned.
     * 
     * @return the reservationType value.
     */
    public ReservationType reservationType() {
        return this.innerProperties() == null ? null : this.innerProperties().reservationType();
    }

    /**
     * Set the reservationType property: Indicates the type of capacity reservation. Allowed values are 'Block' for
     * block capacity reservations and 'Targeted' for reservations that enable a VM to consume a specific capacity
     * reservation when a capacity reservation group is provided. The reservation type is immutable and cannot be
     * changed after it is assigned.
     * 
     * @param reservationType the reservationType value to set.
     * @return the CapacityReservationGroupUpdate object itself.
     */
    public CapacityReservationGroupUpdate withReservationType(ReservationType reservationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CapacityReservationGroupProperties();
        }
        this.innerProperties().withReservationType(reservationType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CapacityReservationGroupUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CapacityReservationGroupUpdate if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CapacityReservationGroupUpdate.
     */
    public static CapacityReservationGroupUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CapacityReservationGroupUpdate deserializedCapacityReservationGroupUpdate
                = new CapacityReservationGroupUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCapacityReservationGroupUpdate.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedCapacityReservationGroupUpdate.innerProperties
                        = CapacityReservationGroupProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapacityReservationGroupUpdate;
        });
    }
}
