// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsDeletingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingById;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsListingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsBatchCreation;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsCreating;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsDeletingById;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListing;

/** Entry point to availability set management API. */
@Fluent
public interface AvailabilitySets extends SupportsListingByResourceGroup<AvailabilitySet>,
    SupportsGettingByResourceGroup<AvailabilitySet>, SupportsGettingById<AvailabilitySet>,
    SupportsListing<AvailabilitySet>, SupportsCreating<AvailabilitySet.DefinitionStages.Blank>, SupportsDeletingById,
    SupportsDeletingByResourceGroup, SupportsBatchCreation<AvailabilitySet>, HasManager<ComputeManager> {
}
