// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * In the case of an availability or connectivity issue with the data disk, specify the behavior of your VM.
 */
@Fluent
public final class AvailabilityPolicy implements JsonSerializable<AvailabilityPolicy> {
    /*
     * Determines on how to handle disks with slow I/O.
     */
    private AvailabilityPolicyDiskDelay actionOnDiskDelay;

    /**
     * Creates an instance of AvailabilityPolicy class.
     */
    public AvailabilityPolicy() {
    }

    /**
     * Get the actionOnDiskDelay property: Determines on how to handle disks with slow I/O.
     * 
     * @return the actionOnDiskDelay value.
     */
    public AvailabilityPolicyDiskDelay actionOnDiskDelay() {
        return this.actionOnDiskDelay;
    }

    /**
     * Set the actionOnDiskDelay property: Determines on how to handle disks with slow I/O.
     * 
     * @param actionOnDiskDelay the actionOnDiskDelay value to set.
     * @return the AvailabilityPolicy object itself.
     */
    public AvailabilityPolicy withActionOnDiskDelay(AvailabilityPolicyDiskDelay actionOnDiskDelay) {
        this.actionOnDiskDelay = actionOnDiskDelay;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionOnDiskDelay",
            this.actionOnDiskDelay == null ? null : this.actionOnDiskDelay.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailabilityPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailabilityPolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvailabilityPolicy.
     */
    public static AvailabilityPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailabilityPolicy deserializedAvailabilityPolicy = new AvailabilityPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionOnDiskDelay".equals(fieldName)) {
                    deserializedAvailabilityPolicy.actionOnDiskDelay
                        = AvailabilityPolicyDiskDelay.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailabilityPolicy;
        });
    }
}
