// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the additional replica set information.
 */
@Fluent
public final class AdditionalReplicaSet implements JsonSerializable<AdditionalReplicaSet> {
    /*
     * Specifies the storage account type to be used to create the direct drive replicas
     */
    private StorageAccountType storageAccountType;

    /*
     * The number of direct drive replicas of the Image Version to be created.This Property is updatable
     */
    private Integer regionalReplicaCount;

    /**
     * Creates an instance of AdditionalReplicaSet class.
     */
    public AdditionalReplicaSet() {
    }

    /**
     * Get the storageAccountType property: Specifies the storage account type to be used to create the direct drive
     * replicas.
     * 
     * @return the storageAccountType value.
     */
    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    /**
     * Set the storageAccountType property: Specifies the storage account type to be used to create the direct drive
     * replicas.
     * 
     * @param storageAccountType the storageAccountType value to set.
     * @return the AdditionalReplicaSet object itself.
     */
    public AdditionalReplicaSet withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    /**
     * Get the regionalReplicaCount property: The number of direct drive replicas of the Image Version to be
     * created.This Property is updatable.
     * 
     * @return the regionalReplicaCount value.
     */
    public Integer regionalReplicaCount() {
        return this.regionalReplicaCount;
    }

    /**
     * Set the regionalReplicaCount property: The number of direct drive replicas of the Image Version to be
     * created.This Property is updatable.
     * 
     * @param regionalReplicaCount the regionalReplicaCount value to set.
     * @return the AdditionalReplicaSet object itself.
     */
    public AdditionalReplicaSet withRegionalReplicaCount(Integer regionalReplicaCount) {
        this.regionalReplicaCount = regionalReplicaCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountType",
            this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeNumberField("regionalReplicaCount", this.regionalReplicaCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdditionalReplicaSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdditionalReplicaSet if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AdditionalReplicaSet.
     */
    public static AdditionalReplicaSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdditionalReplicaSet deserializedAdditionalReplicaSet = new AdditionalReplicaSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountType".equals(fieldName)) {
                    deserializedAdditionalReplicaSet.storageAccountType
                        = StorageAccountType.fromString(reader.getString());
                } else if ("regionalReplicaCount".equals(fieldName)) {
                    deserializedAdditionalReplicaSet.regionalReplicaCount = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdditionalReplicaSet;
        });
    }
}
