// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.GalleryScriptVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptVersionInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionList;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GalleryScriptVersionsClient.
 */
public final class GalleryScriptVersionsClientImpl implements GalleryScriptVersionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GalleryScriptVersionsService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryScriptVersionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    GalleryScriptVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(GalleryScriptVersionsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientGalleryScriptVersions to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementClientGalleryScriptVersions")
    public interface GalleryScriptVersionsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryScriptVersionList>> listByGalleryScript(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryScriptName") String galleryScriptName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryScriptVersionInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryScriptName") String galleryScriptName,
            @PathParam("galleryScriptVersionName") String galleryScriptVersionName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryScriptName") String galleryScriptName,
            @PathParam("galleryScriptVersionName") String galleryScriptVersionName,
            @BodyParam("application/json") GalleryScriptVersionInner galleryScriptVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryScriptName") String galleryScriptName,
            @PathParam("galleryScriptVersionName") String galleryScriptVersionName,
            @BodyParam("application/json") GalleryScriptVersionUpdate galleryScriptVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("galleryScriptName") String galleryScriptName,
            @PathParam("galleryScriptVersionName") String galleryScriptVersionName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryScriptVersionList>> listByGalleryScriptNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptSinglePageAsync(String resourceGroupName,
        String galleryName, String galleryScriptName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGalleryScript(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, accept, context))
            .<PagedResponse<GalleryScriptVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptSinglePageAsync(String resourceGroupName,
        String galleryName, String galleryScriptName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByGalleryScript(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, galleryName, galleryScriptName, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GalleryScriptVersionInner> listByGalleryScriptAsync(String resourceGroupName, String galleryName,
        String galleryScriptName) {
        return new PagedFlux<>(
            () -> listByGalleryScriptSinglePageAsync(resourceGroupName, galleryName, galleryScriptName),
            nextLink -> listByGalleryScriptNextSinglePageAsync(nextLink));
    }

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GalleryScriptVersionInner> listByGalleryScriptAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, Context context) {
        return new PagedFlux<>(
            () -> listByGalleryScriptSinglePageAsync(resourceGroupName, galleryName, galleryScriptName, context),
            nextLink -> listByGalleryScriptNextSinglePageAsync(nextLink, context));
    }

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryScriptVersionInner> listByGalleryScript(String resourceGroupName, String galleryName,
        String galleryScriptName) {
        return new PagedIterable<>(listByGalleryScriptAsync(resourceGroupName, galleryName, galleryScriptName));
    }

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryScriptVersionInner> listByGalleryScript(String resourceGroupName, String galleryName,
        String galleryScriptName, Context context) {
        return new PagedIterable<>(
            listByGalleryScriptAsync(resourceGroupName, galleryName, galleryScriptName, context));
    }

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GalleryScriptVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GalleryScriptVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, galleryScriptName, galleryScriptVersionName, accept, context);
    }

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryScriptVersionInner> getAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName) {
        return getWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GalleryScriptVersionInner> getWithResponse(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, Context context) {
        return getWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            context).block();
    }

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryScriptVersionInner get(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName) {
        return getWithResponse(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            Context.NONE).getValue();
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        } else {
            galleryScriptVersion.validate();
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName,
                galleryScriptVersionName, galleryScriptVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        } else {
            galleryScriptVersion.validate();
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, accept,
            context);
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, galleryName,
            galleryScriptName, galleryScriptVersionName, galleryScriptVersion);
        return this.client.<GalleryScriptVersionInner, GalleryScriptVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryScriptVersionInner.class, GalleryScriptVersionInner.class,
            this.client.getContext());
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, galleryName,
            galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context);
        return this.client.<GalleryScriptVersionInner, GalleryScriptVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryScriptVersionInner.class, GalleryScriptVersionInner.class, context);
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
                galleryScriptVersion)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
                galleryScriptVersion, context)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryScriptVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryScriptVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryScriptVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion) {
        return createOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion).block();
    }

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryScriptVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion, context).block();
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        } else {
            galleryScriptVersion.validate();
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName,
                galleryScriptVersionName, galleryScriptVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        } else {
            galleryScriptVersion.validate();
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, accept, context);
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionUpdate galleryScriptVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, galleryName,
            galleryScriptName, galleryScriptVersionName, galleryScriptVersion);
        return this.client.<GalleryScriptVersionInner, GalleryScriptVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryScriptVersionInner.class, GalleryScriptVersionInner.class,
            this.client.getContext());
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, galleryName,
            galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context);
        return this.client.<GalleryScriptVersionInner, GalleryScriptVersionInner>getLroResult(mono,
            this.client.getHttpPipeline(), GalleryScriptVersionInner.class, GalleryScriptVersionInner.class, context);
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdate(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionUpdate galleryScriptVersion) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
                galleryScriptVersion)
            .getSyncPoller();
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdate(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
                galleryScriptVersion, context)
            .getSyncPoller();
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryScriptVersionInner> updateAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryScriptVersionInner> updateAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion,
        Context context) {
        return beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryScriptVersionInner update(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        return updateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion).block();
    }

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryScriptVersionInner update(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        return updateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName,
            galleryScriptVersion, context).block();
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                    resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            galleryName, galleryScriptName, galleryScriptVersionName, accept, context);
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, galleryName,
            galleryScriptName, galleryScriptVersionName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName)
            .getSyncPoller();
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, Context context) {
        return this
            .beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context)
            .getSyncPoller();
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, Context context) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName) {
        deleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName).block();
    }

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, Context context) {
        deleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByGalleryScriptNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<GalleryScriptVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByGalleryScriptNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
