// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings;
import java.io.IOException;

/**
 * Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.
 */
@Fluent
public final class VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties
    implements JsonSerializable<VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties> {
    /*
     * The idle timeout of the public IP address.
     */
    private Integer idleTimeoutInMinutes;

    /*
     * The dns settings to be applied on the publicIP addresses .
     */
    private VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings;

    /*
     * The PublicIPPrefix from which to allocate publicIP addresses.
     */
    private SubResource publicIpPrefix;

    /*
     * Specify what happens to the public IP when the VM is deleted
     */
    private DeleteOptions deleteOption;

    /**
     * Creates an instance of VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties class.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties() {
    }

    /**
     * Get the idleTimeoutInMinutes property: The idle timeout of the public IP address.
     * 
     * @return the idleTimeoutInMinutes value.
     */
    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    /**
     * Set the idleTimeoutInMinutes property: The idle timeout of the public IP address.
     * 
     * @param idleTimeoutInMinutes the idleTimeoutInMinutes value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties
        withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    /**
     * Get the dnsSettings property: The dns settings to be applied on the publicIP addresses .
     * 
     * @return the dnsSettings value.
     */
    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    /**
     * Set the dnsSettings property: The dns settings to be applied on the publicIP addresses .
     * 
     * @param dnsSettings the dnsSettings value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties
        withDnsSettings(VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    /**
     * Get the publicIpPrefix property: The PublicIPPrefix from which to allocate publicIP addresses.
     * 
     * @return the publicIpPrefix value.
     */
    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    /**
     * Set the publicIpPrefix property: The PublicIPPrefix from which to allocate publicIP addresses.
     * 
     * @param publicIpPrefix the publicIpPrefix value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties
        withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    /**
     * Get the deleteOption property: Specify what happens to the public IP when the VM is deleted.
     * 
     * @return the deleteOption value.
     */
    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    /**
     * Set the deleteOption property: Specify what happens to the public IP when the VM is deleted.
     * 
     * @param deleteOption the deleteOption value to set.
     * @return the VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties object itself.
     */
    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties
        withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dnsSettings() != null) {
            dnsSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("idleTimeoutInMinutes", this.idleTimeoutInMinutes);
        jsonWriter.writeJsonField("dnsSettings", this.dnsSettings);
        jsonWriter.writeJsonField("publicIPPrefix", this.publicIpPrefix);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties if the JsonReader was
     * pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.
     */
    public static VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties
                = new VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.idleTimeoutInMinutes
                        = reader.getNullable(JsonReader::getInt);
                } else if ("dnsSettings".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.dnsSettings
                        = VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings.fromJson(reader);
                } else if ("publicIPPrefix".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.publicIpPrefix
                        = SubResource.fromJson(reader);
                } else if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.deleteOption
                        = DeleteOptions.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties;
        });
    }
}
