// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a Virtual Machine Extension Image.
 */
@Fluent
public final class VirtualMachineExtensionImageProperties
    implements JsonSerializable<VirtualMachineExtensionImageProperties> {
    /*
     * The operating system this extension supports.
     */
    private String operatingSystem;

    /*
     * The type of role (IaaS or PaaS) this extension supports.
     */
    private String computeRole;

    /*
     * The schema defined by publisher, where extension consumers should provide settings in a matching schema.
     */
    private String handlerSchema;

    /*
     * Whether the extension can be used on xRP VMScaleSets. By default existing extensions are usable on scalesets, but
     * there might be cases where a publisher wants to explicitly indicate the extension is only enabled for CRP VMs but
     * not VMSS.
     */
    private Boolean vmScaleSetEnabled;

    /*
     * Whether the handler can support multiple extensions.
     */
    private Boolean supportsMultipleExtensions;

    /**
     * Creates an instance of VirtualMachineExtensionImageProperties class.
     */
    public VirtualMachineExtensionImageProperties() {
    }

    /**
     * Get the operatingSystem property: The operating system this extension supports.
     * 
     * @return the operatingSystem value.
     */
    public String operatingSystem() {
        return this.operatingSystem;
    }

    /**
     * Set the operatingSystem property: The operating system this extension supports.
     * 
     * @param operatingSystem the operatingSystem value to set.
     * @return the VirtualMachineExtensionImageProperties object itself.
     */
    public VirtualMachineExtensionImageProperties withOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    /**
     * Get the computeRole property: The type of role (IaaS or PaaS) this extension supports.
     * 
     * @return the computeRole value.
     */
    public String computeRole() {
        return this.computeRole;
    }

    /**
     * Set the computeRole property: The type of role (IaaS or PaaS) this extension supports.
     * 
     * @param computeRole the computeRole value to set.
     * @return the VirtualMachineExtensionImageProperties object itself.
     */
    public VirtualMachineExtensionImageProperties withComputeRole(String computeRole) {
        this.computeRole = computeRole;
        return this;
    }

    /**
     * Get the handlerSchema property: The schema defined by publisher, where extension consumers should provide
     * settings in a matching schema.
     * 
     * @return the handlerSchema value.
     */
    public String handlerSchema() {
        return this.handlerSchema;
    }

    /**
     * Set the handlerSchema property: The schema defined by publisher, where extension consumers should provide
     * settings in a matching schema.
     * 
     * @param handlerSchema the handlerSchema value to set.
     * @return the VirtualMachineExtensionImageProperties object itself.
     */
    public VirtualMachineExtensionImageProperties withHandlerSchema(String handlerSchema) {
        this.handlerSchema = handlerSchema;
        return this;
    }

    /**
     * Get the vmScaleSetEnabled property: Whether the extension can be used on xRP VMScaleSets. By default existing
     * extensions are usable on scalesets, but there might be cases where a publisher wants to explicitly indicate the
     * extension is only enabled for CRP VMs but not VMSS.
     * 
     * @return the vmScaleSetEnabled value.
     */
    public Boolean vmScaleSetEnabled() {
        return this.vmScaleSetEnabled;
    }

    /**
     * Set the vmScaleSetEnabled property: Whether the extension can be used on xRP VMScaleSets. By default existing
     * extensions are usable on scalesets, but there might be cases where a publisher wants to explicitly indicate the
     * extension is only enabled for CRP VMs but not VMSS.
     * 
     * @param vmScaleSetEnabled the vmScaleSetEnabled value to set.
     * @return the VirtualMachineExtensionImageProperties object itself.
     */
    public VirtualMachineExtensionImageProperties withVmScaleSetEnabled(Boolean vmScaleSetEnabled) {
        this.vmScaleSetEnabled = vmScaleSetEnabled;
        return this;
    }

    /**
     * Get the supportsMultipleExtensions property: Whether the handler can support multiple extensions.
     * 
     * @return the supportsMultipleExtensions value.
     */
    public Boolean supportsMultipleExtensions() {
        return this.supportsMultipleExtensions;
    }

    /**
     * Set the supportsMultipleExtensions property: Whether the handler can support multiple extensions.
     * 
     * @param supportsMultipleExtensions the supportsMultipleExtensions value to set.
     * @return the VirtualMachineExtensionImageProperties object itself.
     */
    public VirtualMachineExtensionImageProperties withSupportsMultipleExtensions(Boolean supportsMultipleExtensions) {
        this.supportsMultipleExtensions = supportsMultipleExtensions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operatingSystem() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property operatingSystem in model VirtualMachineExtensionImageProperties"));
        }
        if (computeRole() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property computeRole in model VirtualMachineExtensionImageProperties"));
        }
        if (handlerSchema() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property handlerSchema in model VirtualMachineExtensionImageProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineExtensionImageProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operatingSystem", this.operatingSystem);
        jsonWriter.writeStringField("computeRole", this.computeRole);
        jsonWriter.writeStringField("handlerSchema", this.handlerSchema);
        jsonWriter.writeBooleanField("vmScaleSetEnabled", this.vmScaleSetEnabled);
        jsonWriter.writeBooleanField("supportsMultipleExtensions", this.supportsMultipleExtensions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineExtensionImageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineExtensionImageProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineExtensionImageProperties.
     */
    public static VirtualMachineExtensionImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineExtensionImageProperties deserializedVirtualMachineExtensionImageProperties
                = new VirtualMachineExtensionImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operatingSystem".equals(fieldName)) {
                    deserializedVirtualMachineExtensionImageProperties.operatingSystem = reader.getString();
                } else if ("computeRole".equals(fieldName)) {
                    deserializedVirtualMachineExtensionImageProperties.computeRole = reader.getString();
                } else if ("handlerSchema".equals(fieldName)) {
                    deserializedVirtualMachineExtensionImageProperties.handlerSchema = reader.getString();
                } else if ("vmScaleSetEnabled".equals(fieldName)) {
                    deserializedVirtualMachineExtensionImageProperties.vmScaleSetEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("supportsMultipleExtensions".equals(fieldName)) {
                    deserializedVirtualMachineExtensionImageProperties.supportsMultipleExtensions
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineExtensionImageProperties;
        });
    }
}
