// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ConsistencyModeTypes;
import com.azure.resourcemanager.compute.models.RestorePointInstanceView;
import com.azure.resourcemanager.compute.models.RestorePointSourceMetadata;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The restore point properties.
 */
@Fluent
public final class RestorePointProperties implements JsonSerializable<RestorePointProperties> {
    /*
     * List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified,
     * all disks will be included.
     */
    private List<ApiEntityReference> excludeDisks;

    /*
     * Gets the details of the VM captured at the time of the restore point creation.
     */
    private RestorePointSourceMetadata sourceMetadata;

    /*
     * Gets the provisioning state of the restore point.
     */
    private String provisioningState;

    /*
     * ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only
     * CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
     */
    private ConsistencyModeTypes consistencyMode;

    /*
     * Gets the creation time of the restore point.
     */
    private OffsetDateTime timeCreated;

    /*
     * Resource Id of the source restore point from which a copy needs to be created.
     */
    private ApiEntityReference sourceRestorePoint;

    /*
     * The restore point instance view.
     */
    private RestorePointInstanceView instanceView;

    /*
     * This property determines the time in minutes the snapshot is retained as instant access for restoring Premium SSD
     * v2 or Ultra disk with fast restore performance in this restore point.
     */
    private Integer instantAccessDurationMinutes;

    /**
     * Creates an instance of RestorePointProperties class.
     */
    public RestorePointProperties() {
    }

    /**
     * Get the excludeDisks property: List of disk resource ids that the customer wishes to exclude from the restore
     * point. If no disks are specified, all disks will be included.
     * 
     * @return the excludeDisks value.
     */
    public List<ApiEntityReference> excludeDisks() {
        return this.excludeDisks;
    }

    /**
     * Set the excludeDisks property: List of disk resource ids that the customer wishes to exclude from the restore
     * point. If no disks are specified, all disks will be included.
     * 
     * @param excludeDisks the excludeDisks value to set.
     * @return the RestorePointProperties object itself.
     */
    public RestorePointProperties withExcludeDisks(List<ApiEntityReference> excludeDisks) {
        this.excludeDisks = excludeDisks;
        return this;
    }

    /**
     * Get the sourceMetadata property: Gets the details of the VM captured at the time of the restore point creation.
     * 
     * @return the sourceMetadata value.
     */
    public RestorePointSourceMetadata sourceMetadata() {
        return this.sourceMetadata;
    }

    /**
     * Set the sourceMetadata property: Gets the details of the VM captured at the time of the restore point creation.
     * 
     * @param sourceMetadata the sourceMetadata value to set.
     * @return the RestorePointProperties object itself.
     */
    public RestorePointProperties withSourceMetadata(RestorePointSourceMetadata sourceMetadata) {
        this.sourceMetadata = sourceMetadata;
        return this;
    }

    /**
     * Get the provisioningState property: Gets the provisioning state of the restore point.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the consistencyMode property: ConsistencyMode of the RestorePoint. Can be specified in the input while
     * creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to
     * https://aka.ms/RestorePoints for more details.
     * 
     * @return the consistencyMode value.
     */
    public ConsistencyModeTypes consistencyMode() {
        return this.consistencyMode;
    }

    /**
     * Set the consistencyMode property: ConsistencyMode of the RestorePoint. Can be specified in the input while
     * creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to
     * https://aka.ms/RestorePoints for more details.
     * 
     * @param consistencyMode the consistencyMode value to set.
     * @return the RestorePointProperties object itself.
     */
    public RestorePointProperties withConsistencyMode(ConsistencyModeTypes consistencyMode) {
        this.consistencyMode = consistencyMode;
        return this;
    }

    /**
     * Get the timeCreated property: Gets the creation time of the restore point.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Set the timeCreated property: Gets the creation time of the restore point.
     * 
     * @param timeCreated the timeCreated value to set.
     * @return the RestorePointProperties object itself.
     */
    public RestorePointProperties withTimeCreated(OffsetDateTime timeCreated) {
        this.timeCreated = timeCreated;
        return this;
    }

    /**
     * Get the sourceRestorePoint property: Resource Id of the source restore point from which a copy needs to be
     * created.
     * 
     * @return the sourceRestorePoint value.
     */
    public ApiEntityReference sourceRestorePoint() {
        return this.sourceRestorePoint;
    }

    /**
     * Set the sourceRestorePoint property: Resource Id of the source restore point from which a copy needs to be
     * created.
     * 
     * @param sourceRestorePoint the sourceRestorePoint value to set.
     * @return the RestorePointProperties object itself.
     */
    public RestorePointProperties withSourceRestorePoint(ApiEntityReference sourceRestorePoint) {
        this.sourceRestorePoint = sourceRestorePoint;
        return this;
    }

    /**
     * Get the instanceView property: The restore point instance view.
     * 
     * @return the instanceView value.
     */
    public RestorePointInstanceView instanceView() {
        return this.instanceView;
    }

    /**
     * Get the instantAccessDurationMinutes property: This property determines the time in minutes the snapshot is
     * retained as instant access for restoring Premium SSD v2 or Ultra disk with fast restore performance in this
     * restore point.
     * 
     * @return the instantAccessDurationMinutes value.
     */
    public Integer instantAccessDurationMinutes() {
        return this.instantAccessDurationMinutes;
    }

    /**
     * Set the instantAccessDurationMinutes property: This property determines the time in minutes the snapshot is
     * retained as instant access for restoring Premium SSD v2 or Ultra disk with fast restore performance in this
     * restore point.
     * 
     * @param instantAccessDurationMinutes the instantAccessDurationMinutes value to set.
     * @return the RestorePointProperties object itself.
     */
    public RestorePointProperties withInstantAccessDurationMinutes(Integer instantAccessDurationMinutes) {
        this.instantAccessDurationMinutes = instantAccessDurationMinutes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (excludeDisks() != null) {
            excludeDisks().forEach(e -> e.validate());
        }
        if (sourceMetadata() != null) {
            sourceMetadata().validate();
        }
        if (sourceRestorePoint() != null) {
            sourceRestorePoint().validate();
        }
        if (instanceView() != null) {
            instanceView().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("excludeDisks", this.excludeDisks, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("sourceMetadata", this.sourceMetadata);
        jsonWriter.writeStringField("consistencyMode",
            this.consistencyMode == null ? null : this.consistencyMode.toString());
        jsonWriter.writeStringField("timeCreated",
            this.timeCreated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timeCreated));
        jsonWriter.writeJsonField("sourceRestorePoint", this.sourceRestorePoint);
        jsonWriter.writeNumberField("instantAccessDurationMinutes", this.instantAccessDurationMinutes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorePointProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorePointProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorePointProperties.
     */
    public static RestorePointProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointProperties deserializedRestorePointProperties = new RestorePointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("excludeDisks".equals(fieldName)) {
                    List<ApiEntityReference> excludeDisks
                        = reader.readArray(reader1 -> ApiEntityReference.fromJson(reader1));
                    deserializedRestorePointProperties.excludeDisks = excludeDisks;
                } else if ("sourceMetadata".equals(fieldName)) {
                    deserializedRestorePointProperties.sourceMetadata = RestorePointSourceMetadata.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRestorePointProperties.provisioningState = reader.getString();
                } else if ("consistencyMode".equals(fieldName)) {
                    deserializedRestorePointProperties.consistencyMode
                        = ConsistencyModeTypes.fromString(reader.getString());
                } else if ("timeCreated".equals(fieldName)) {
                    deserializedRestorePointProperties.timeCreated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("sourceRestorePoint".equals(fieldName)) {
                    deserializedRestorePointProperties.sourceRestorePoint = ApiEntityReference.fromJson(reader);
                } else if ("instanceView".equals(fieldName)) {
                    deserializedRestorePointProperties.instanceView = RestorePointInstanceView.fromJson(reader);
                } else if ("instantAccessDurationMinutes".equals(fieldName)) {
                    deserializedRestorePointProperties.instantAccessDurationMinutes
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorePointProperties;
        });
    }
}
