// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ConsistencyModeTypes;
import com.azure.resourcemanager.compute.models.RestorePointInstanceView;
import com.azure.resourcemanager.compute.models.RestorePointSourceMetadata;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Restore Point details.
 */
@Fluent
public final class RestorePointInner extends ProxyResource {
    /*
     * The restore point properties.
     */
    private RestorePointProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RestorePointInner class.
     */
    public RestorePointInner() {
    }

    /**
     * Get the innerProperties property: The restore point properties.
     * 
     * @return the innerProperties value.
     */
    private RestorePointProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the excludeDisks property: List of disk resource ids that the customer wishes to exclude from the restore
     * point. If no disks are specified, all disks will be included.
     * 
     * @return the excludeDisks value.
     */
    public List<ApiEntityReference> excludeDisks() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeDisks();
    }

    /**
     * Set the excludeDisks property: List of disk resource ids that the customer wishes to exclude from the restore
     * point. If no disks are specified, all disks will be included.
     * 
     * @param excludeDisks the excludeDisks value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withExcludeDisks(List<ApiEntityReference> excludeDisks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withExcludeDisks(excludeDisks);
        return this;
    }

    /**
     * Get the sourceMetadata property: Gets the details of the VM captured at the time of the restore point creation.
     * 
     * @return the sourceMetadata value.
     */
    public RestorePointSourceMetadata sourceMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceMetadata();
    }

    /**
     * Set the sourceMetadata property: Gets the details of the VM captured at the time of the restore point creation.
     * 
     * @param sourceMetadata the sourceMetadata value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withSourceMetadata(RestorePointSourceMetadata sourceMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withSourceMetadata(sourceMetadata);
        return this;
    }

    /**
     * Get the provisioningState property: Gets the provisioning state of the restore point.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the consistencyMode property: ConsistencyMode of the RestorePoint. Can be specified in the input while
     * creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to
     * https://aka.ms/RestorePoints for more details.
     * 
     * @return the consistencyMode value.
     */
    public ConsistencyModeTypes consistencyMode() {
        return this.innerProperties() == null ? null : this.innerProperties().consistencyMode();
    }

    /**
     * Set the consistencyMode property: ConsistencyMode of the RestorePoint. Can be specified in the input while
     * creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to
     * https://aka.ms/RestorePoints for more details.
     * 
     * @param consistencyMode the consistencyMode value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withConsistencyMode(ConsistencyModeTypes consistencyMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withConsistencyMode(consistencyMode);
        return this;
    }

    /**
     * Get the timeCreated property: Gets the creation time of the restore point.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    /**
     * Set the timeCreated property: Gets the creation time of the restore point.
     * 
     * @param timeCreated the timeCreated value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withTimeCreated(OffsetDateTime timeCreated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withTimeCreated(timeCreated);
        return this;
    }

    /**
     * Get the sourceRestorePoint property: Resource Id of the source restore point from which a copy needs to be
     * created.
     * 
     * @return the sourceRestorePoint value.
     */
    public ApiEntityReference sourceRestorePoint() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceRestorePoint();
    }

    /**
     * Set the sourceRestorePoint property: Resource Id of the source restore point from which a copy needs to be
     * created.
     * 
     * @param sourceRestorePoint the sourceRestorePoint value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withSourceRestorePoint(ApiEntityReference sourceRestorePoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withSourceRestorePoint(sourceRestorePoint);
        return this;
    }

    /**
     * Get the instanceView property: The restore point instance view.
     * 
     * @return the instanceView value.
     */
    public RestorePointInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    /**
     * Get the instantAccessDurationMinutes property: This property determines the time in minutes the snapshot is
     * retained as instant access for restoring Premium SSD v2 or Ultra disk with fast restore performance in this
     * restore point.
     * 
     * @return the instantAccessDurationMinutes value.
     */
    public Integer instantAccessDurationMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().instantAccessDurationMinutes();
    }

    /**
     * Set the instantAccessDurationMinutes property: This property determines the time in minutes the snapshot is
     * retained as instant access for restoring Premium SSD v2 or Ultra disk with fast restore performance in this
     * restore point.
     * 
     * @param instantAccessDurationMinutes the instantAccessDurationMinutes value to set.
     * @return the RestorePointInner object itself.
     */
    public RestorePointInner withInstantAccessDurationMinutes(Integer instantAccessDurationMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withInstantAccessDurationMinutes(instantAccessDurationMinutes);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorePointInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorePointInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RestorePointInner.
     */
    public static RestorePointInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointInner deserializedRestorePointInner = new RestorePointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRestorePointInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRestorePointInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRestorePointInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRestorePointInner.innerProperties = RestorePointProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedRestorePointInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorePointInner;
        });
    }
}
