// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.LogAnalyticsOutput;
import java.io.IOException;

/**
 * LogAnalytics operation status response.
 */
@Immutable
public final class LogAnalyticsOperationResultInner implements JsonSerializable<LogAnalyticsOperationResultInner> {
    /*
     * LogAnalyticsOutput
     */
    private LogAnalyticsOutput properties;

    /**
     * Creates an instance of LogAnalyticsOperationResultInner class.
     */
    public LogAnalyticsOperationResultInner() {
    }

    /**
     * Get the properties property: LogAnalyticsOutput.
     * 
     * @return the properties value.
     */
    public LogAnalyticsOutput properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogAnalyticsOperationResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogAnalyticsOperationResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LogAnalyticsOperationResultInner.
     */
    public static LogAnalyticsOperationResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogAnalyticsOperationResultInner deserializedLogAnalyticsOperationResultInner
                = new LogAnalyticsOperationResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedLogAnalyticsOperationResultInner.properties = LogAnalyticsOutput.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogAnalyticsOperationResultInner;
        });
    }
}
