// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import java.io.IOException;

/**
 * Describes the properties of a gallery script version.
 */
@Fluent
public final class GalleryScriptVersionProperties implements JsonSerializable<GalleryScriptVersionProperties> {
    /*
     * The publishing profile of a gallery image version.
     */
    private GalleryScriptVersionPublishingProfile publishingProfile;

    /*
     * The safety profile of the Gallery Script Version.
     */
    private GalleryScriptVersionSafetyProfile safetyProfile;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /*
     * This is the replication status of the gallery image version.
     */
    private ReplicationStatus replicationStatus;

    /**
     * Creates an instance of GalleryScriptVersionProperties class.
     */
    public GalleryScriptVersionProperties() {
    }

    /**
     * Get the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @return the publishingProfile value.
     */
    public GalleryScriptVersionPublishingProfile publishingProfile() {
        return this.publishingProfile;
    }

    /**
     * Set the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @param publishingProfile the publishingProfile value to set.
     * @return the GalleryScriptVersionProperties object itself.
     */
    public GalleryScriptVersionProperties
        withPublishingProfile(GalleryScriptVersionPublishingProfile publishingProfile) {
        this.publishingProfile = publishingProfile;
        return this;
    }

    /**
     * Get the safetyProfile property: The safety profile of the Gallery Script Version.
     * 
     * @return the safetyProfile value.
     */
    public GalleryScriptVersionSafetyProfile safetyProfile() {
        return this.safetyProfile;
    }

    /**
     * Set the safetyProfile property: The safety profile of the Gallery Script Version.
     * 
     * @param safetyProfile the safetyProfile value to set.
     * @return the GalleryScriptVersionProperties object itself.
     */
    public GalleryScriptVersionProperties withSafetyProfile(GalleryScriptVersionSafetyProfile safetyProfile) {
        this.safetyProfile = safetyProfile;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publishingProfile() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property publishingProfile in model GalleryScriptVersionProperties"));
        } else {
            publishingProfile().validate();
        }
        if (safetyProfile() != null) {
            safetyProfile().validate();
        }
        if (replicationStatus() != null) {
            replicationStatus().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptVersionProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("publishingProfile", this.publishingProfile);
        jsonWriter.writeJsonField("safetyProfile", this.safetyProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryScriptVersionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryScriptVersionProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryScriptVersionProperties.
     */
    public static GalleryScriptVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryScriptVersionProperties deserializedGalleryScriptVersionProperties
                = new GalleryScriptVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publishingProfile".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.publishingProfile
                        = GalleryScriptVersionPublishingProfile.fromJson(reader);
                } else if ("safetyProfile".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.safetyProfile
                        = GalleryScriptVersionSafetyProfile.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.replicationStatus = ReplicationStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryScriptVersionProperties;
        });
    }
}
