// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Describes the properties of a gallery script definition.
 */
@Fluent
public final class GalleryScriptProperties implements JsonSerializable<GalleryScriptProperties> {
    /*
     * The description of this gallery script definition resource. This property is updatable.
     */
    private String description;

    /*
     * The Eula agreement (End User License Agreement) for the gallery Script Definition.
     */
    private String eula;

    /*
     * The privacy statement uri.
     */
    private String privacyStatementUri;

    /*
     * The release note uri.
     */
    private String releaseNoteUri;

    /*
     * The end of life date of the gallery Script Definition. This property can be used for decommissioning purposes.
     * This property is updatable.
     */
    private OffsetDateTime endOfLifeDate;

    /*
     * This property allows you to specify the supported type of the OS that application is built for. Possible values
     * are: **Windows,** **Linux.**
     */
    private OperatingSystemTypes supportedOSType;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /**
     * Creates an instance of GalleryScriptProperties class.
     */
    public GalleryScriptProperties() {
    }

    /**
     * Get the description property: The description of this gallery script definition resource. This property is
     * updatable.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of this gallery script definition resource. This property is
     * updatable.
     * 
     * @param description the description value to set.
     * @return the GalleryScriptProperties object itself.
     */
    public GalleryScriptProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the eula property: The Eula agreement (End User License Agreement) for the gallery Script Definition.
     * 
     * @return the eula value.
     */
    public String eula() {
        return this.eula;
    }

    /**
     * Set the eula property: The Eula agreement (End User License Agreement) for the gallery Script Definition.
     * 
     * @param eula the eula value to set.
     * @return the GalleryScriptProperties object itself.
     */
    public GalleryScriptProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    /**
     * Get the privacyStatementUri property: The privacy statement uri.
     * 
     * @return the privacyStatementUri value.
     */
    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    /**
     * Set the privacyStatementUri property: The privacy statement uri.
     * 
     * @param privacyStatementUri the privacyStatementUri value to set.
     * @return the GalleryScriptProperties object itself.
     */
    public GalleryScriptProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    /**
     * Get the releaseNoteUri property: The release note uri.
     * 
     * @return the releaseNoteUri value.
     */
    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    /**
     * Set the releaseNoteUri property: The release note uri.
     * 
     * @param releaseNoteUri the releaseNoteUri value to set.
     * @return the GalleryScriptProperties object itself.
     */
    public GalleryScriptProperties withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    /**
     * Get the endOfLifeDate property: The end of life date of the gallery Script Definition. This property can be used
     * for decommissioning purposes. This property is updatable.
     * 
     * @return the endOfLifeDate value.
     */
    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    /**
     * Set the endOfLifeDate property: The end of life date of the gallery Script Definition. This property can be used
     * for decommissioning purposes. This property is updatable.
     * 
     * @param endOfLifeDate the endOfLifeDate value to set.
     * @return the GalleryScriptProperties object itself.
     */
    public GalleryScriptProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    /**
     * Get the supportedOSType property: This property allows you to specify the supported type of the OS that
     * application is built for. Possible values are: **Windows,** **Linux.**.
     * 
     * @return the supportedOSType value.
     */
    public OperatingSystemTypes supportedOSType() {
        return this.supportedOSType;
    }

    /**
     * Set the supportedOSType property: This property allows you to specify the supported type of the OS that
     * application is built for. Possible values are: **Windows,** **Linux.**.
     * 
     * @param supportedOSType the supportedOSType value to set.
     * @return the GalleryScriptProperties object itself.
     */
    public GalleryScriptProperties withSupportedOSType(OperatingSystemTypes supportedOSType) {
        this.supportedOSType = supportedOSType;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedOSType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property supportedOSType in model GalleryScriptProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("supportedOSType",
            this.supportedOSType == null ? null : this.supportedOSType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        jsonWriter.writeStringField("releaseNoteUri", this.releaseNoteUri);
        jsonWriter.writeStringField("endOfLifeDate",
            this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryScriptProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryScriptProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryScriptProperties.
     */
    public static GalleryScriptProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryScriptProperties deserializedGalleryScriptProperties = new GalleryScriptProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("supportedOSType".equals(fieldName)) {
                    deserializedGalleryScriptProperties.supportedOSType
                        = OperatingSystemTypes.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedGalleryScriptProperties.description = reader.getString();
                } else if ("eula".equals(fieldName)) {
                    deserializedGalleryScriptProperties.eula = reader.getString();
                } else if ("privacyStatementUri".equals(fieldName)) {
                    deserializedGalleryScriptProperties.privacyStatementUri = reader.getString();
                } else if ("releaseNoteUri".equals(fieldName)) {
                    deserializedGalleryScriptProperties.releaseNoteUri = reader.getString();
                } else if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryScriptProperties.endOfLifeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryScriptProperties.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryScriptProperties;
        });
    }
}
