// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryIdentifier;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.SharingProfile;
import com.azure.resourcemanager.compute.models.SharingStatus;
import com.azure.resourcemanager.compute.models.SoftDeletePolicy;
import java.io.IOException;

/**
 * Describes the properties of a Shared Image Gallery.
 */
@Fluent
public final class GalleryProperties implements JsonSerializable<GalleryProperties> {
    /*
     * The description of this Shared Image Gallery resource. This property is updatable.
     */
    private String description;

    /*
     * Describes the gallery unique name.
     */
    private GalleryIdentifier identifier;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /*
     * Profile for gallery sharing to subscription or tenant
     */
    private SharingProfile sharingProfile;

    /*
     * Contains information about the soft deletion policy of the gallery.
     */
    private SoftDeletePolicy softDeletePolicy;

    /*
     * Sharing status of current gallery.
     */
    private SharingStatus sharingStatus;

    /**
     * Creates an instance of GalleryProperties class.
     */
    public GalleryProperties() {
    }

    /**
     * Get the description property: The description of this Shared Image Gallery resource. This property is updatable.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of this Shared Image Gallery resource. This property is updatable.
     * 
     * @param description the description value to set.
     * @return the GalleryProperties object itself.
     */
    public GalleryProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the identifier property: Describes the gallery unique name.
     * 
     * @return the identifier value.
     */
    public GalleryIdentifier identifier() {
        return this.identifier;
    }

    /**
     * Set the identifier property: Describes the gallery unique name.
     * 
     * @param identifier the identifier value to set.
     * @return the GalleryProperties object itself.
     */
    public GalleryProperties withIdentifier(GalleryIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the sharingProfile property: Profile for gallery sharing to subscription or tenant.
     * 
     * @return the sharingProfile value.
     */
    public SharingProfile sharingProfile() {
        return this.sharingProfile;
    }

    /**
     * Set the sharingProfile property: Profile for gallery sharing to subscription or tenant.
     * 
     * @param sharingProfile the sharingProfile value to set.
     * @return the GalleryProperties object itself.
     */
    public GalleryProperties withSharingProfile(SharingProfile sharingProfile) {
        this.sharingProfile = sharingProfile;
        return this;
    }

    /**
     * Get the softDeletePolicy property: Contains information about the soft deletion policy of the gallery.
     * 
     * @return the softDeletePolicy value.
     */
    public SoftDeletePolicy softDeletePolicy() {
        return this.softDeletePolicy;
    }

    /**
     * Set the softDeletePolicy property: Contains information about the soft deletion policy of the gallery.
     * 
     * @param softDeletePolicy the softDeletePolicy value to set.
     * @return the GalleryProperties object itself.
     */
    public GalleryProperties withSoftDeletePolicy(SoftDeletePolicy softDeletePolicy) {
        this.softDeletePolicy = softDeletePolicy;
        return this;
    }

    /**
     * Get the sharingStatus property: Sharing status of current gallery.
     * 
     * @return the sharingStatus value.
     */
    public SharingStatus sharingStatus() {
        return this.sharingStatus;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identifier() != null) {
            identifier().validate();
        }
        if (sharingProfile() != null) {
            sharingProfile().validate();
        }
        if (softDeletePolicy() != null) {
            softDeletePolicy().validate();
        }
        if (sharingStatus() != null) {
            sharingStatus().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("identifier", this.identifier);
        jsonWriter.writeJsonField("sharingProfile", this.sharingProfile);
        jsonWriter.writeJsonField("softDeletePolicy", this.softDeletePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryProperties.
     */
    public static GalleryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryProperties deserializedGalleryProperties = new GalleryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedGalleryProperties.description = reader.getString();
                } else if ("identifier".equals(fieldName)) {
                    deserializedGalleryProperties.identifier = GalleryIdentifier.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryProperties.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else if ("sharingProfile".equals(fieldName)) {
                    deserializedGalleryProperties.sharingProfile = SharingProfile.fromJson(reader);
                } else if ("softDeletePolicy".equals(fieldName)) {
                    deserializedGalleryProperties.softDeletePolicy = SoftDeletePolicy.fromJson(reader);
                } else if ("sharingStatus".equals(fieldName)) {
                    deserializedGalleryProperties.sharingStatus = SharingStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryProperties;
        });
    }
}
