// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AccessControlRules;
import com.azure.resourcemanager.compute.models.AccessControlRulesMode;
import com.azure.resourcemanager.compute.models.EndpointAccess;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Specifies information about the gallery inVMAccessControlProfile version that you want to create or update.
 */
@Fluent
public final class GalleryInVMAccessControlProfileVersionInner extends Resource {
    /*
     * Describes the properties of an inVMAccessControlProfile version.
     */
    private GalleryInVMAccessControlProfileVersionProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GalleryInVMAccessControlProfileVersionInner class.
     */
    public GalleryInVMAccessControlProfileVersionInner() {
    }

    /**
     * Get the innerProperties property: Describes the properties of an inVMAccessControlProfile version.
     * 
     * @return the innerProperties value.
     */
    private GalleryInVMAccessControlProfileVersionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInVMAccessControlProfileVersionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInVMAccessControlProfileVersionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the mode property: This property allows you to specify whether the access control rules are in Audit mode, in
     * Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     * 
     * @return the mode value.
     */
    public AccessControlRulesMode mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    /**
     * Set the mode property: This property allows you to specify whether the access control rules are in Audit mode, in
     * Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     * 
     * @param mode the mode value to set.
     * @return the GalleryInVMAccessControlProfileVersionInner object itself.
     */
    public GalleryInVMAccessControlProfileVersionInner withMode(AccessControlRulesMode mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    /**
     * Get the defaultAccess property: This property allows you to specify if the requests will be allowed to access the
     * host endpoints. Possible values are: 'Allow', 'Deny'.
     * 
     * @return the defaultAccess value.
     */
    public EndpointAccess defaultAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultAccess();
    }

    /**
     * Set the defaultAccess property: This property allows you to specify if the requests will be allowed to access the
     * host endpoints. Possible values are: 'Allow', 'Deny'.
     * 
     * @param defaultAccess the defaultAccess value to set.
     * @return the GalleryInVMAccessControlProfileVersionInner object itself.
     */
    public GalleryInVMAccessControlProfileVersionInner withDefaultAccess(EndpointAccess defaultAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withDefaultAccess(defaultAccess);
        return this;
    }

    /**
     * Get the rules property: This is the Access Control Rules specification for an inVMAccessControlProfile version.
     * 
     * @return the rules value.
     */
    public AccessControlRules rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: This is the Access Control Rules specification for an inVMAccessControlProfile version.
     * 
     * @param rules the rules value to set.
     * @return the GalleryInVMAccessControlProfileVersionInner object itself.
     */
    public GalleryInVMAccessControlProfileVersionInner withRules(AccessControlRules rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Get the targetLocations property: The target regions where the Resource Profile version is going to be replicated
     * to. This property is updatable.
     * 
     * @return the targetLocations value.
     */
    public List<TargetRegion> targetLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().targetLocations();
    }

    /**
     * Set the targetLocations property: The target regions where the Resource Profile version is going to be replicated
     * to. This property is updatable.
     * 
     * @param targetLocations the targetLocations value to set.
     * @return the GalleryInVMAccessControlProfileVersionInner object itself.
     */
    public GalleryInVMAccessControlProfileVersionInner withTargetLocations(List<TargetRegion> targetLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withTargetLocations(targetLocations);
        return this;
    }

    /**
     * Get the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Resource Profile won't use this Profile version.
     * 
     * @return the excludeFromLatest value.
     */
    public Boolean excludeFromLatest() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeFromLatest();
    }

    /**
     * Set the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Resource Profile won't use this Profile version.
     * 
     * @param excludeFromLatest the excludeFromLatest value to set.
     * @return the GalleryInVMAccessControlProfileVersionInner object itself.
     */
    public GalleryInVMAccessControlProfileVersionInner withExcludeFromLatest(Boolean excludeFromLatest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    /**
     * Get the publishedDate property: The timestamp for when the Resource Profile Version is published.
     * 
     * @return the publishedDate value.
     */
    public OffsetDateTime publishedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().publishedDate();
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInVMAccessControlProfileVersionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInVMAccessControlProfileVersionInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryInVMAccessControlProfileVersionInner.
     */
    public static GalleryInVMAccessControlProfileVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileVersionInner deserializedGalleryInVMAccessControlProfileVersionInner
                = new GalleryInVMAccessControlProfileVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryInVMAccessControlProfileVersionInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.innerProperties
                        = GalleryInVMAccessControlProfileVersionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInVMAccessControlProfileVersionInner;
        });
    }
}
