// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentBaseInner;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineRunCommandInner;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in VirtualMachineRunCommandsClient.
 */
public interface VirtualMachineRunCommandsClient {
    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The name of Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RunCommandDocumentBaseInner> listAsync(String location);

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The name of Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RunCommandDocumentBaseInner> list(String location);

    /**
     * Lists all available run commands for a subscription in a location.
     * 
     * @param location The name of Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RunCommandDocumentBaseInner> list(String location, Context context);

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The name of Azure region.
     * @param commandId Specifies a commandId of predefined built-in script. Command IDs available for Linux are listed
     * at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     * https://aka.ms/RunCommandManagedWindows#available-commands.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RunCommandDocumentInner>> getWithResponseAsync(String location, String commandId);

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The name of Azure region.
     * @param commandId Specifies a commandId of predefined built-in script. Command IDs available for Linux are listed
     * at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     * https://aka.ms/RunCommandManagedWindows#available-commands.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RunCommandDocumentInner> getAsync(String location, String commandId);

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The name of Azure region.
     * @param commandId Specifies a commandId of predefined built-in script. Command IDs available for Linux are listed
     * at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     * https://aka.ms/RunCommandManagedWindows#available-commands.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RunCommandDocumentInner> getWithResponse(String location, String commandId, Context context);

    /**
     * Gets specific run command for a subscription in a location.
     * 
     * @param location The name of Azure region.
     * @param commandId Specifies a commandId of predefined built-in script. Command IDs available for Linux are listed
     * at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     * https://aka.ms/RunCommandManagedWindows#available-commands.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specific run command for a subscription in a location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunCommandDocumentInner get(String location, String commandId);

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName,
        String expand);

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName);

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName);

    /**
     * The operation to get all run commands of a Virtual Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List run command operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName,
        String expand, Context context);

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VirtualMachineRunCommandInner>> getByVirtualMachineWithResponseAsync(String resourceGroupName,
        String vmName, String runCommandName, String expand);

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName,
        String runCommandName);

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VirtualMachineRunCommandInner> getByVirtualMachineWithResponse(String resourceGroupName, String vmName,
        String runCommandName, String expand, Context context);

    /**
     * The operation to get the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineRunCommandInner getByVirtualMachine(String resourceGroupName, String vmName, String runCommandName);

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandInner runCommand);

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand);

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand);

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand,
        Context context);

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandInner runCommand);

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandInner runCommand);

    /**
     * The operation to create or update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandInner runCommand, Context context);

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName, VirtualMachineRunCommandUpdate runCommand);

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdateAsync(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand);

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand);

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(
        String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand,
        Context context);

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand);

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand);

    /**
     * The operation to update the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Virtual Machine run command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName,
        VirtualMachineRunCommandUpdate runCommand, Context context);

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName,
        String runCommandName);

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName, String runCommandName);

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName, String runCommandName);

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName, String runCommandName,
        Context context);

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName);

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String vmName, String runCommandName);

    /**
     * The operation to delete the run command.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vmName The name of the VirtualMachine.
     * @param runCommandName The name of the VirtualMachineRunCommand.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String vmName, String runCommandName, Context context);
}
