// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptInner;
import com.azure.resourcemanager.compute.models.GalleryScriptUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GalleryScriptsClient.
 */
public interface GalleryScriptsClient {
    /**
     * List gallery Script Definitions in a gallery.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Script operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GalleryScriptInner> listByGalleryAsync(String resourceGroupName, String galleryName);

    /**
     * List gallery Script Definitions in a gallery.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Script operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryScriptInner> listByGallery(String resourceGroupName, String galleryName);

    /**
     * List gallery Script Definitions in a gallery.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Script operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryScriptInner> listByGallery(String resourceGroupName, String galleryName, Context context);

    /**
     * Retrieves information about a gallery script definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<GalleryScriptInner>> getWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName);

    /**
     * Retrieves information about a gallery script definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryScriptInner> getAsync(String resourceGroupName, String galleryName, String galleryScriptName);

    /**
     * Retrieves information about a gallery script definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GalleryScriptInner> getWithResponse(String resourceGroupName, String galleryName, String galleryScriptName,
        Context context);

    /**
     * Retrieves information about a gallery script definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptInner get(String resourceGroupName, String galleryName, String galleryScriptName);

    /**
     * Create or update a Gallery Script Definition. Gallery scripts allow the storage, sharing and reuse of common
     * scripts.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the create or update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, GalleryScriptInner galleryScript);

    /**
     * Create or update a Gallery Script Definition. Gallery scripts allow the storage, sharing and reuse of common
     * scripts.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the create or update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery Script Definition that you
     * want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryScriptInner>, GalleryScriptInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String galleryName, String galleryScriptName, GalleryScriptInner galleryScript);

    /**
     * Create or update a Gallery Script Definition. Gallery scripts allow the storage, sharing and reuse of common
     * scripts.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the create or update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery Script Definition that you
     * want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginCreateOrUpdate(String resourceGroupName,
        String galleryName, String galleryScriptName, GalleryScriptInner galleryScript);

    /**
     * Create or update a Gallery Script Definition. Gallery scripts allow the storage, sharing and reuse of common
     * scripts.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the create or update gallery Script operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery Script Definition that you
     * want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginCreateOrUpdate(String resourceGroupName,
        String galleryName, String galleryScriptName, GalleryScriptInner galleryScript, Context context);

    /**
     * Create or update a Gallery Script Definition. Gallery scripts allow the storage, sharing and reuse of common
     * scripts.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the create or update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryScriptInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName,
        GalleryScriptInner galleryScript);

    /**
     * Create or update a Gallery Script Definition. Gallery scripts allow the storage, sharing and reuse of common
     * scripts.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the create or update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName,
        GalleryScriptInner galleryScript);

    /**
     * Create or update a Gallery Script Definition. Gallery scripts allow the storage, sharing and reuse of common
     * scripts.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the create or update gallery Script operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName,
        GalleryScriptInner galleryScript, Context context);

    /**
     * Update a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, GalleryScriptUpdate galleryScript);

    /**
     * Update a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery Script Definition that you
     * want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryScriptInner>, GalleryScriptInner> beginUpdateAsync(String resourceGroupName,
        String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript);

    /**
     * Update a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery Script Definition that you
     * want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginUpdate(String resourceGroupName,
        String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript);

    /**
     * Update a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the update gallery Script operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery Script Definition that you
     * want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginUpdate(String resourceGroupName,
        String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript, Context context);

    /**
     * Update a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryScriptInner> updateAsync(String resourceGroupName, String galleryName, String galleryScriptName,
        GalleryScriptUpdate galleryScript);

    /**
     * Update a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the update gallery Script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptInner update(String resourceGroupName, String galleryName, String galleryScriptName,
        GalleryScriptUpdate galleryScript);

    /**
     * Update a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScript Parameters supplied to the update gallery Script operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Script Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptInner update(String resourceGroupName, String galleryName, String galleryScriptName,
        GalleryScriptUpdate galleryScript, Context context);

    /**
     * Delete a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName);

    /**
     * Delete a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String galleryScriptName);

    /**
     * Delete a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryScriptName);

    /**
     * Delete a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryScriptName, Context context);

    /**
     * Delete a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName);

    /**
     * Delete a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String galleryScriptName);

    /**
     * Delete a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String galleryScriptName, Context context);
}
