// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptVersionInner;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GalleryScriptVersionsClient.
 */
public interface GalleryScriptVersionsClient {
    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GalleryScriptVersionInner> listByGalleryScriptAsync(String resourceGroupName, String galleryName,
        String galleryScriptName);

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryScriptVersionInner> listByGalleryScript(String resourceGroupName, String galleryName,
        String galleryScriptName);

    /**
     * List gallery Script Versions in a gallery Script Definition.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of GalleryScriptVersion items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryScriptVersionInner> listByGalleryScript(String resourceGroupName, String galleryName,
        String galleryScriptName, Context context);

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<GalleryScriptVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName);

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryScriptVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName);

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GalleryScriptVersionInner> getWithResponse(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, Context context);

    /**
     * Custom ArmResourceRead operation template with CloudError as Error.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptVersionInner get(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName);

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion);

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion);

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion);

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionInner galleryScriptVersion, Context context);

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryScriptVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion);

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion);

    /**
     * Create or update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the create or update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion, Context context);

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion);

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionUpdate galleryScriptVersion);

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdate(String resourceGroupName,
        String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionUpdate galleryScriptVersion);

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of concrete tracked resource types can be created by aliasing this
     * type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdate(String resourceGroupName,
        String galleryName, String galleryScriptName, String galleryScriptVersionName,
        GalleryScriptVersionUpdate galleryScriptVersion, Context context);

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryScriptVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion);

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptVersionInner update(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion);

    /**
     * Update a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param galleryScriptVersion Parameters supplied to the update gallery Script Version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryScriptVersionInner update(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion, Context context);

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName);

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName);

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName);

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String galleryScriptName, String galleryScriptVersionName, Context context);

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName);

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String galleryScriptName,
        String galleryScriptVersionName);

    /**
     * Delete a gallery Script Version.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param galleryName The name of the Shared Image Gallery.
     * @param galleryScriptName The name of the gallery Script Definition to be retrieved.
     * @param galleryScriptVersionName The name of the gallery Script Version to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName,
        Context context);
}
