// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.AvailabilitySetInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import com.azure.resourcemanager.compute.models.AvailabilitySetUpdate;
import com.azure.resourcemanager.compute.models.ConvertToVirtualMachineScaleSetInput;
import com.azure.resourcemanager.compute.models.MigrateToVirtualMachineScaleSetInput;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AvailabilitySetsClient.
 */
public interface AvailabilitySetsClient extends InnerSupportsGet<AvailabilitySetInner>,
    InnerSupportsListing<AvailabilitySetInner>, InnerSupportsDelete<Void> {
    /**
     * Lists all availability sets in a subscription.
     * 
     * @param expand The expand expression to apply to the operation. Allowed values are 'instanceView'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Availability Set operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AvailabilitySetInner> listAsync(String expand);

    /**
     * Lists all availability sets in a subscription.
     * 
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Availability Set operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AvailabilitySetInner> listAsync();

    /**
     * Lists all availability sets in a subscription.
     * 
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Availability Set operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AvailabilitySetInner> list();

    /**
     * Lists all availability sets in a subscription.
     * 
     * @param expand The expand expression to apply to the operation. Allowed values are 'instanceView'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Availability Set operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AvailabilitySetInner> list(String expand, Context context);

    /**
     * Lists all availability sets in a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Availability Set operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AvailabilitySetInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all availability sets in a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Availability Set operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AvailabilitySetInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all availability sets in a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Availability Set operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AvailabilitySetInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Retrieves information about an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AvailabilitySetInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String availabilitySetName);

    /**
     * Retrieves information about an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AvailabilitySetInner> getByResourceGroupAsync(String resourceGroupName, String availabilitySetName);

    /**
     * Retrieves information about an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AvailabilitySetInner> getByResourceGroupWithResponse(String resourceGroupName, String availabilitySetName,
        Context context);

    /**
     * Retrieves information about an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AvailabilitySetInner getByResourceGroup(String resourceGroupName, String availabilitySetName);

    /**
     * Create or update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Create Availability Set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AvailabilitySetInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String availabilitySetName, AvailabilitySetInner parameters);

    /**
     * Create or update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Create Availability Set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AvailabilitySetInner> createOrUpdateAsync(String resourceGroupName, String availabilitySetName,
        AvailabilitySetInner parameters);

    /**
     * Create or update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Create Availability Set operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AvailabilitySetInner> createOrUpdateWithResponse(String resourceGroupName, String availabilitySetName,
        AvailabilitySetInner parameters, Context context);

    /**
     * Create or update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Create Availability Set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AvailabilitySetInner createOrUpdate(String resourceGroupName, String availabilitySetName,
        AvailabilitySetInner parameters);

    /**
     * Update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Update Availability Set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AvailabilitySetInner>> updateWithResponseAsync(String resourceGroupName, String availabilitySetName,
        AvailabilitySetUpdate parameters);

    /**
     * Update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Update Availability Set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AvailabilitySetInner> updateAsync(String resourceGroupName, String availabilitySetName,
        AvailabilitySetUpdate parameters);

    /**
     * Update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Update Availability Set operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AvailabilitySetInner> updateWithResponse(String resourceGroupName, String availabilitySetName,
        AvailabilitySetUpdate parameters, Context context);

    /**
     * Update an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the Update Availability Set operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the availability set that the virtual machine should be assigned to.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AvailabilitySetInner update(String resourceGroupName, String availabilitySetName, AvailabilitySetUpdate parameters);

    /**
     * Delete an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String availabilitySetName);

    /**
     * Delete an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String availabilitySetName);

    /**
     * Delete an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String availabilitySetName, Context context);

    /**
     * Delete an availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String availabilitySetName);

    /**
     * Cancel the migration operation on an Availability Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> cancelMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName,
        String availabilitySetName);

    /**
     * Cancel the migration operation on an Availability Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> cancelMigrationToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName);

    /**
     * Cancel the migration operation on an Availability Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> cancelMigrationToVirtualMachineScaleSetWithResponse(String resourceGroupName,
        String availabilitySetName, Context context);

    /**
     * Cancel the migration operation on an Availability Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancelMigrationToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> convertToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName,
        String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSetAsync(String resourceGroupName,
        String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSetAsync(String resourceGroupName,
        String availabilitySetName);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSet(String resourceGroupName,
        String availabilitySetName);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSet(String resourceGroupName,
        String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters, Context context);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> convertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName,
        ConvertToVirtualMachineScaleSetInput parameters);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> convertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void convertToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName);

    /**
     * Create a new Flexible Virtual Machine Scale Set and migrate all the Virtual Machines in the Availability Set.
     * This does not trigger a downtime on the Virtual Machines.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void convertToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName,
        ConvertToVirtualMachineScaleSetInput parameters, Context context);

    /**
     * Start migration operation on an Availability Set to move its Virtual Machines to a Virtual Machine Scale Set.
     * This should be followed by a migrate operation on each Virtual Machine that triggers a downtime on the Virtual
     * Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> startMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName,
        String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters);

    /**
     * Start migration operation on an Availability Set to move its Virtual Machines to a Virtual Machine Scale Set.
     * This should be followed by a migrate operation on each Virtual Machine that triggers a downtime on the Virtual
     * Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> startMigrationToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName,
        MigrateToVirtualMachineScaleSetInput parameters);

    /**
     * Start migration operation on an Availability Set to move its Virtual Machines to a Virtual Machine Scale Set.
     * This should be followed by a migrate operation on each Virtual Machine that triggers a downtime on the Virtual
     * Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> startMigrationToVirtualMachineScaleSetWithResponse(String resourceGroupName,
        String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters, Context context);

    /**
     * Start migration operation on an Availability Set to move its Virtual Machines to a Virtual Machine Scale Set.
     * This should be followed by a migrate operation on each Virtual Machine that triggers a downtime on the Virtual
     * Machine.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void startMigrationToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName,
        MigrateToVirtualMachineScaleSetInput parameters);

    /**
     * Validates that the Virtual Machines in the Availability Set can be migrated to the provided Virtual Machine Scale
     * Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> validateMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName,
        String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters);

    /**
     * Validates that the Virtual Machines in the Availability Set can be migrated to the provided Virtual Machine Scale
     * Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> validateMigrationToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName,
        MigrateToVirtualMachineScaleSetInput parameters);

    /**
     * Validates that the Virtual Machines in the Availability Set can be migrated to the provided Virtual Machine Scale
     * Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> validateMigrationToVirtualMachineScaleSetWithResponse(String resourceGroupName,
        String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters, Context context);

    /**
     * Validates that the Virtual Machines in the Availability Set can be migrated to the provided Virtual Machine Scale
     * Set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param parameters Parameters supplied to the migrate operation on the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void validateMigrationToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName,
        MigrateToVirtualMachineScaleSetInput parameters);

    /**
     * Lists all available virtual machine sizes that can be used to create a new virtual machine in an existing
     * availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualMachineSizeInner> listAvailableSizesAsync(String resourceGroupName, String availabilitySetName);

    /**
     * Lists all available virtual machine sizes that can be used to create a new virtual machine in an existing
     * availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String availabilitySetName);

    /**
     * Lists all available virtual machine sizes that can be used to create a new virtual machine in an existing
     * availability set.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param availabilitySetName The name of the availability set.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Virtual Machine operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String availabilitySetName,
        Context context);
}
