/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.KeyVaultSecretReference;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineExtensionProperties
implements JsonSerializable<VirtualMachineExtensionProperties> {
    private String forceUpdateTag;
    private String publisher;
    private String type;
    private String typeHandlerVersion;
    private Boolean autoUpgradeMinorVersion;
    private Boolean enableAutomaticUpgrade;
    private Object settings;
    private Object protectedSettings;
    private String provisioningState;
    private VirtualMachineExtensionInstanceView instanceView;
    private Boolean suppressFailures;
    private KeyVaultSecretReference protectedSettingsFromKeyVault;
    private List<String> provisionAfterExtensions;

    public String forceUpdateTag() {
        return this.forceUpdateTag;
    }

    public VirtualMachineExtensionProperties withForceUpdateTag(String forceUpdateTag) {
        this.forceUpdateTag = forceUpdateTag;
        return this;
    }

    public String publisher() {
        return this.publisher;
    }

    public VirtualMachineExtensionProperties withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public String type() {
        return this.type;
    }

    public VirtualMachineExtensionProperties withType(String type) {
        this.type = type;
        return this;
    }

    public String typeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    public VirtualMachineExtensionProperties withTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    public Boolean autoUpgradeMinorVersion() {
        return this.autoUpgradeMinorVersion;
    }

    public VirtualMachineExtensionProperties withAutoUpgradeMinorVersion(Boolean autoUpgradeMinorVersion) {
        this.autoUpgradeMinorVersion = autoUpgradeMinorVersion;
        return this;
    }

    public Boolean enableAutomaticUpgrade() {
        return this.enableAutomaticUpgrade;
    }

    public VirtualMachineExtensionProperties withEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        this.enableAutomaticUpgrade = enableAutomaticUpgrade;
        return this;
    }

    public Object settings() {
        return this.settings;
    }

    public VirtualMachineExtensionProperties withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    public Object protectedSettings() {
        return this.protectedSettings;
    }

    public VirtualMachineExtensionProperties withProtectedSettings(Object protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineExtensionInstanceView instanceView() {
        return this.instanceView;
    }

    public VirtualMachineExtensionProperties withInstanceView(VirtualMachineExtensionInstanceView instanceView) {
        this.instanceView = instanceView;
        return this;
    }

    public Boolean suppressFailures() {
        return this.suppressFailures;
    }

    public VirtualMachineExtensionProperties withSuppressFailures(Boolean suppressFailures) {
        this.suppressFailures = suppressFailures;
        return this;
    }

    public KeyVaultSecretReference protectedSettingsFromKeyVault() {
        return this.protectedSettingsFromKeyVault;
    }

    public VirtualMachineExtensionProperties withProtectedSettingsFromKeyVault(KeyVaultSecretReference protectedSettingsFromKeyVault) {
        this.protectedSettingsFromKeyVault = protectedSettingsFromKeyVault;
        return this;
    }

    public List<String> provisionAfterExtensions() {
        return this.provisionAfterExtensions;
    }

    public VirtualMachineExtensionProperties withProvisionAfterExtensions(List<String> provisionAfterExtensions) {
        this.provisionAfterExtensions = provisionAfterExtensions;
        return this;
    }

    public void validate() {
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.protectedSettingsFromKeyVault() != null) {
            this.protectedSettingsFromKeyVault().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("forceUpdateTag", this.forceUpdateTag);
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeBooleanField("autoUpgradeMinorVersion", this.autoUpgradeMinorVersion);
        jsonWriter.writeBooleanField("enableAutomaticUpgrade", this.enableAutomaticUpgrade);
        if (this.settings != null) {
            jsonWriter.writeUntypedField("settings", this.settings);
        }
        if (this.protectedSettings != null) {
            jsonWriter.writeUntypedField("protectedSettings", this.protectedSettings);
        }
        jsonWriter.writeJsonField("instanceView", (JsonSerializable)this.instanceView);
        jsonWriter.writeBooleanField("suppressFailures", this.suppressFailures);
        jsonWriter.writeJsonField("protectedSettingsFromKeyVault", (JsonSerializable)this.protectedSettingsFromKeyVault);
        jsonWriter.writeArrayField("provisionAfterExtensions", this.provisionAfterExtensions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineExtensionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineExtensionProperties)jsonReader.readObject(reader -> {
            VirtualMachineExtensionProperties deserializedVirtualMachineExtensionProperties = new VirtualMachineExtensionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("forceUpdateTag".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.forceUpdateTag = reader.getString();
                    continue;
                }
                if ("publisher".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.publisher = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.type = reader.getString();
                    continue;
                }
                if ("typeHandlerVersion".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.typeHandlerVersion = reader.getString();
                    continue;
                }
                if ("autoUpgradeMinorVersion".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.autoUpgradeMinorVersion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticUpgrade".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.enableAutomaticUpgrade = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.settings = reader.readUntyped();
                    continue;
                }
                if ("protectedSettings".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.protectedSettings = reader.readUntyped();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.instanceView = VirtualMachineExtensionInstanceView.fromJson(reader);
                    continue;
                }
                if ("suppressFailures".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.suppressFailures = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("protectedSettingsFromKeyVault".equals(fieldName)) {
                    deserializedVirtualMachineExtensionProperties.protectedSettingsFromKeyVault = KeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("provisionAfterExtensions".equals(fieldName)) {
                    List provisionAfterExtensions;
                    deserializedVirtualMachineExtensionProperties.provisionAfterExtensions = provisionAfterExtensions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineExtensionProperties;
        });
    }
}

