/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineExtensionInstanceView
implements JsonSerializable<VirtualMachineExtensionInstanceView> {
    private String name;
    private String type;
    private String typeHandlerVersion;
    private List<InstanceViewStatus> substatuses;
    private List<InstanceViewStatus> statuses;

    public String name() {
        return this.name;
    }

    public VirtualMachineExtensionInstanceView withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public VirtualMachineExtensionInstanceView withType(String type) {
        this.type = type;
        return this;
    }

    public String typeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    public VirtualMachineExtensionInstanceView withTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    public List<InstanceViewStatus> substatuses() {
        return this.substatuses;
    }

    public VirtualMachineExtensionInstanceView withSubstatuses(List<InstanceViewStatus> substatuses) {
        this.substatuses = substatuses;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public VirtualMachineExtensionInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.substatuses() != null) {
            this.substatuses().forEach(e -> e.validate());
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeArrayField("substatuses", this.substatuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineExtensionInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineExtensionInstanceView)jsonReader.readObject(reader -> {
            VirtualMachineExtensionInstanceView deserializedVirtualMachineExtensionInstanceView = new VirtualMachineExtensionInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineExtensionInstanceView.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineExtensionInstanceView.type = reader.getString();
                    continue;
                }
                if ("typeHandlerVersion".equals(fieldName)) {
                    deserializedVirtualMachineExtensionInstanceView.typeHandlerVersion = reader.getString();
                    continue;
                }
                if ("substatuses".equals(fieldName)) {
                    List substatuses;
                    deserializedVirtualMachineExtensionInstanceView.substatuses = substatuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedVirtualMachineExtensionInstanceView.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineExtensionInstanceView;
        });
    }
}

