/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.VMScaleSetScaleOutInputProperties;
import java.io.IOException;

public final class VMScaleSetScaleOutInput
implements JsonSerializable<VMScaleSetScaleOutInput> {
    private long capacity;
    private VMScaleSetScaleOutInputProperties properties;

    public long capacity() {
        return this.capacity;
    }

    public VMScaleSetScaleOutInput withCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public VMScaleSetScaleOutInputProperties properties() {
        return this.properties;
    }

    public VMScaleSetScaleOutInput withProperties(VMScaleSetScaleOutInputProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("capacity", this.capacity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static VMScaleSetScaleOutInput fromJson(JsonReader jsonReader) throws IOException {
        return (VMScaleSetScaleOutInput)jsonReader.readObject(reader -> {
            VMScaleSetScaleOutInput deserializedVMScaleSetScaleOutInput = new VMScaleSetScaleOutInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capacity".equals(fieldName)) {
                    deserializedVMScaleSetScaleOutInput.capacity = reader.getLong();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVMScaleSetScaleOutInput.properties = VMScaleSetScaleOutInputProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVMScaleSetScaleOutInput;
        });
    }
}

