/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SshPublicKey;
import java.io.IOException;
import java.util.List;

public final class SshConfiguration
implements JsonSerializable<SshConfiguration> {
    private List<SshPublicKey> publicKeys;

    public List<SshPublicKey> publicKeys() {
        return this.publicKeys;
    }

    public SshConfiguration withPublicKeys(List<SshPublicKey> publicKeys) {
        this.publicKeys = publicKeys;
        return this;
    }

    public void validate() {
        if (this.publicKeys() != null) {
            this.publicKeys().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("publicKeys", this.publicKeys, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SshConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (SshConfiguration)jsonReader.readObject(reader -> {
            SshConfiguration deserializedSshConfiguration = new SshConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicKeys".equals(fieldName)) {
                    List publicKeys;
                    deserializedSshConfiguration.publicKeys = publicKeys = reader.readArray(reader1 -> SshPublicKey.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSshConfiguration;
        });
    }
}

