/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AutomaticZoneRebalancingPolicy;
import com.azure.resourcemanager.compute.models.ResilientVMCreationPolicy;
import com.azure.resourcemanager.compute.models.ResilientVMDeletionPolicy;
import com.azure.resourcemanager.compute.models.ZoneAllocationPolicy;
import java.io.IOException;

public final class ResiliencyPolicy
implements JsonSerializable<ResiliencyPolicy> {
    private ResilientVMCreationPolicy resilientVMCreationPolicy;
    private ResilientVMDeletionPolicy resilientVMDeletionPolicy;
    private AutomaticZoneRebalancingPolicy automaticZoneRebalancingPolicy;
    private ZoneAllocationPolicy zoneAllocationPolicy;

    public ResilientVMCreationPolicy resilientVMCreationPolicy() {
        return this.resilientVMCreationPolicy;
    }

    public ResiliencyPolicy withResilientVMCreationPolicy(ResilientVMCreationPolicy resilientVMCreationPolicy) {
        this.resilientVMCreationPolicy = resilientVMCreationPolicy;
        return this;
    }

    public ResilientVMDeletionPolicy resilientVMDeletionPolicy() {
        return this.resilientVMDeletionPolicy;
    }

    public ResiliencyPolicy withResilientVMDeletionPolicy(ResilientVMDeletionPolicy resilientVMDeletionPolicy) {
        this.resilientVMDeletionPolicy = resilientVMDeletionPolicy;
        return this;
    }

    public AutomaticZoneRebalancingPolicy automaticZoneRebalancingPolicy() {
        return this.automaticZoneRebalancingPolicy;
    }

    public ResiliencyPolicy withAutomaticZoneRebalancingPolicy(AutomaticZoneRebalancingPolicy automaticZoneRebalancingPolicy) {
        this.automaticZoneRebalancingPolicy = automaticZoneRebalancingPolicy;
        return this;
    }

    public ZoneAllocationPolicy zoneAllocationPolicy() {
        return this.zoneAllocationPolicy;
    }

    public ResiliencyPolicy withZoneAllocationPolicy(ZoneAllocationPolicy zoneAllocationPolicy) {
        this.zoneAllocationPolicy = zoneAllocationPolicy;
        return this;
    }

    public void validate() {
        if (this.resilientVMCreationPolicy() != null) {
            this.resilientVMCreationPolicy().validate();
        }
        if (this.resilientVMDeletionPolicy() != null) {
            this.resilientVMDeletionPolicy().validate();
        }
        if (this.automaticZoneRebalancingPolicy() != null) {
            this.automaticZoneRebalancingPolicy().validate();
        }
        if (this.zoneAllocationPolicy() != null) {
            this.zoneAllocationPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resilientVMCreationPolicy", (JsonSerializable)this.resilientVMCreationPolicy);
        jsonWriter.writeJsonField("resilientVMDeletionPolicy", (JsonSerializable)this.resilientVMDeletionPolicy);
        jsonWriter.writeJsonField("automaticZoneRebalancingPolicy", (JsonSerializable)this.automaticZoneRebalancingPolicy);
        jsonWriter.writeJsonField("zoneAllocationPolicy", (JsonSerializable)this.zoneAllocationPolicy);
        return jsonWriter.writeEndObject();
    }

    public static ResiliencyPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ResiliencyPolicy)jsonReader.readObject(reader -> {
            ResiliencyPolicy deserializedResiliencyPolicy = new ResiliencyPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resilientVMCreationPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.resilientVMCreationPolicy = ResilientVMCreationPolicy.fromJson(reader);
                    continue;
                }
                if ("resilientVMDeletionPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.resilientVMDeletionPolicy = ResilientVMDeletionPolicy.fromJson(reader);
                    continue;
                }
                if ("automaticZoneRebalancingPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.automaticZoneRebalancingPolicy = AutomaticZoneRebalancingPolicy.fromJson(reader);
                    continue;
                }
                if ("zoneAllocationPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.zoneAllocationPolicy = ZoneAllocationPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResiliencyPolicy;
        });
    }
}

