// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the policy for resource's placement in availability zone. Possible values are: **Any** (used for Virtual
 * Machines), **Auto** (used for Virtual Machine Scale Sets) - An availability zone will be automatically picked by
 * system as part of resource creation.
 */
public final class ZonePlacementPolicyType extends ExpandableStringEnum<ZonePlacementPolicyType> {
    /**
     * Static value Any for ZonePlacementPolicyType.
     */
    public static final ZonePlacementPolicyType ANY = fromString("Any");

    /**
     * Static value Auto for ZonePlacementPolicyType.
     */
    public static final ZonePlacementPolicyType AUTO = fromString("Auto");

    /**
     * Creates a new instance of ZonePlacementPolicyType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ZonePlacementPolicyType() {
    }

    /**
     * Creates or finds a ZonePlacementPolicyType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ZonePlacementPolicyType.
     */
    public static ZonePlacementPolicyType fromString(String name) {
        return fromString(name, ZonePlacementPolicyType.class);
    }

    /**
     * Gets known ZonePlacementPolicyType values.
     * 
     * @return known ZonePlacementPolicyType values.
     */
    public static Collection<ZonePlacementPolicyType> values() {
        return values(ZonePlacementPolicyType.class);
    }
}
