// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration parameters for zone allocation of a virtual machine scale set.
 */
@Fluent
public final class ZoneAllocationPolicy implements JsonSerializable<ZoneAllocationPolicy> {
    /*
     * The maximum number of availability zones to use if the ZonePlacementPolicy is 'Auto'. If not specified, all
     * availability zones will be used.
     */
    private Integer maxZoneCount;

    /*
     * The configuration parameters used to limit the number of virtual machines per availability zone in the virtual
     * machine scale set.
     */
    private MaxInstancePercentPerZonePolicy maxInstancePercentPerZonePolicy;

    /**
     * Creates an instance of ZoneAllocationPolicy class.
     */
    public ZoneAllocationPolicy() {
    }

    /**
     * Get the maxZoneCount property: The maximum number of availability zones to use if the ZonePlacementPolicy is
     * 'Auto'. If not specified, all availability zones will be used.
     * 
     * @return the maxZoneCount value.
     */
    public Integer maxZoneCount() {
        return this.maxZoneCount;
    }

    /**
     * Set the maxZoneCount property: The maximum number of availability zones to use if the ZonePlacementPolicy is
     * 'Auto'. If not specified, all availability zones will be used.
     * 
     * @param maxZoneCount the maxZoneCount value to set.
     * @return the ZoneAllocationPolicy object itself.
     */
    public ZoneAllocationPolicy withMaxZoneCount(Integer maxZoneCount) {
        this.maxZoneCount = maxZoneCount;
        return this;
    }

    /**
     * Get the maxInstancePercentPerZonePolicy property: The configuration parameters used to limit the number of
     * virtual machines per availability zone in the virtual machine scale set.
     * 
     * @return the maxInstancePercentPerZonePolicy value.
     */
    public MaxInstancePercentPerZonePolicy maxInstancePercentPerZonePolicy() {
        return this.maxInstancePercentPerZonePolicy;
    }

    /**
     * Set the maxInstancePercentPerZonePolicy property: The configuration parameters used to limit the number of
     * virtual machines per availability zone in the virtual machine scale set.
     * 
     * @param maxInstancePercentPerZonePolicy the maxInstancePercentPerZonePolicy value to set.
     * @return the ZoneAllocationPolicy object itself.
     */
    public ZoneAllocationPolicy
        withMaxInstancePercentPerZonePolicy(MaxInstancePercentPerZonePolicy maxInstancePercentPerZonePolicy) {
        this.maxInstancePercentPerZonePolicy = maxInstancePercentPerZonePolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (maxInstancePercentPerZonePolicy() != null) {
            maxInstancePercentPerZonePolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxZoneCount", this.maxZoneCount);
        jsonWriter.writeJsonField("maxInstancePercentPerZonePolicy", this.maxInstancePercentPerZonePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ZoneAllocationPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ZoneAllocationPolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ZoneAllocationPolicy.
     */
    public static ZoneAllocationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ZoneAllocationPolicy deserializedZoneAllocationPolicy = new ZoneAllocationPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxZoneCount".equals(fieldName)) {
                    deserializedZoneAllocationPolicy.maxZoneCount = reader.getNullable(JsonReader::getInt);
                } else if ("maxInstancePercentPerZonePolicy".equals(fieldName)) {
                    deserializedZoneAllocationPolicy.maxInstancePercentPerZonePolicy
                        = MaxInstancePercentPerZonePolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedZoneAllocationPolicy;
        });
    }
}
