// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input properties for ScaleOut.
 */
@Fluent
public final class VMScaleSetScaleOutInputProperties implements JsonSerializable<VMScaleSetScaleOutInputProperties> {
    /*
     * The zone in which the scale out is requested for the virtual machine scale set.
     */
    private String zone;

    /**
     * Creates an instance of VMScaleSetScaleOutInputProperties class.
     */
    public VMScaleSetScaleOutInputProperties() {
    }

    /**
     * Get the zone property: The zone in which the scale out is requested for the virtual machine scale set.
     * 
     * @return the zone value.
     */
    public String zone() {
        return this.zone;
    }

    /**
     * Set the zone property: The zone in which the scale out is requested for the virtual machine scale set.
     * 
     * @param zone the zone value to set.
     * @return the VMScaleSetScaleOutInputProperties object itself.
     */
    public VMScaleSetScaleOutInputProperties withZone(String zone) {
        this.zone = zone;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("zone", this.zone);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VMScaleSetScaleOutInputProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VMScaleSetScaleOutInputProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VMScaleSetScaleOutInputProperties.
     */
    public static VMScaleSetScaleOutInputProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VMScaleSetScaleOutInputProperties deserializedVMScaleSetScaleOutInputProperties
                = new VMScaleSetScaleOutInputProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("zone".equals(fieldName)) {
                    deserializedVMScaleSetScaleOutInputProperties.zone = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVMScaleSetScaleOutInputProperties;
        });
    }
}
