// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input for ScaleOut.
 */
@Fluent
public final class VMScaleSetScaleOutInput implements JsonSerializable<VMScaleSetScaleOutInput> {
    /*
     * Specifies the number of virtual machines in the scale set.
     */
    private long capacity;

    /*
     * The input properties for ScaleOut
     */
    private VMScaleSetScaleOutInputProperties properties;

    /**
     * Creates an instance of VMScaleSetScaleOutInput class.
     */
    public VMScaleSetScaleOutInput() {
    }

    /**
     * Get the capacity property: Specifies the number of virtual machines in the scale set.
     * 
     * @return the capacity value.
     */
    public long capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: Specifies the number of virtual machines in the scale set.
     * 
     * @param capacity the capacity value to set.
     * @return the VMScaleSetScaleOutInput object itself.
     */
    public VMScaleSetScaleOutInput withCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Get the properties property: The input properties for ScaleOut.
     * 
     * @return the properties value.
     */
    public VMScaleSetScaleOutInputProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The input properties for ScaleOut.
     * 
     * @param properties the properties value to set.
     * @return the VMScaleSetScaleOutInput object itself.
     */
    public VMScaleSetScaleOutInput withProperties(VMScaleSetScaleOutInputProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("capacity", this.capacity);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VMScaleSetScaleOutInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VMScaleSetScaleOutInput if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VMScaleSetScaleOutInput.
     */
    public static VMScaleSetScaleOutInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VMScaleSetScaleOutInput deserializedVMScaleSetScaleOutInput = new VMScaleSetScaleOutInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("capacity".equals(fieldName)) {
                    deserializedVMScaleSetScaleOutInput.capacity = reader.getLong();
                } else if ("properties".equals(fieldName)) {
                    deserializedVMScaleSetScaleOutInput.properties = VMScaleSetScaleOutInputProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVMScaleSetScaleOutInput;
        });
    }
}
