// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the schedule for Block-type capacity reservations. Specifies the schedule during which capacity reservation
 * is active and VM or VMSS resource can be allocated using reservation. This property is required and only supported
 * when the capacity reservation group type is 'Block'. The scheduleProfile, start, and end fields are immutable after
 * creation. Minimum API version: 2025-04-01. Please refer to https://aka.ms/blockcapacityreservation for more details.
 */
@Fluent
public final class ScheduleProfile implements JsonSerializable<ScheduleProfile> {
    /*
     * The required start date for block capacity reservations. Must be today or within 56 days in the future. For
     * same-day scheduling, requests must be submitted before 11:30 AM UTC. Example: 2025-06-27.
     */
    private String start;

    /*
     * The required end date for block capacity reservations. Must be after the start date, with a duration of either
     * 1–14 whole days or 3–26 whole weeks. Example: 2025-06-28.
     */
    private String end;

    /**
     * Creates an instance of ScheduleProfile class.
     */
    public ScheduleProfile() {
    }

    /**
     * Get the start property: The required start date for block capacity reservations. Must be today or within 56 days
     * in the future. For same-day scheduling, requests must be submitted before 11:30 AM UTC. Example: 2025-06-27.
     * 
     * @return the start value.
     */
    public String start() {
        return this.start;
    }

    /**
     * Set the start property: The required start date for block capacity reservations. Must be today or within 56 days
     * in the future. For same-day scheduling, requests must be submitted before 11:30 AM UTC. Example: 2025-06-27.
     * 
     * @param start the start value to set.
     * @return the ScheduleProfile object itself.
     */
    public ScheduleProfile withStart(String start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: The required end date for block capacity reservations. Must be after the start date, with a
     * duration of either 1–14 whole days or 3–26 whole weeks. Example: 2025-06-28.
     * 
     * @return the end value.
     */
    public String end() {
        return this.end;
    }

    /**
     * Set the end property: The required end date for block capacity reservations. Must be after the start date, with a
     * duration of either 1–14 whole days or 3–26 whole weeks. Example: 2025-06-28.
     * 
     * @param end the end value to set.
     * @return the ScheduleProfile object itself.
     */
    public ScheduleProfile withEnd(String end) {
        this.end = end;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start", this.start);
        jsonWriter.writeStringField("end", this.end);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScheduleProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScheduleProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScheduleProfile.
     */
    public static ScheduleProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScheduleProfile deserializedScheduleProfile = new ScheduleProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("start".equals(fieldName)) {
                    deserializedScheduleProfile.start = reader.getString();
                } else if ("end".equals(fieldName)) {
                    deserializedScheduleProfile.end = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScheduleProfile;
        });
    }
}
