// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the resilient VM deletion status for the virtual machine.
 */
public final class ResilientVMDeletionStatus extends ExpandableStringEnum<ResilientVMDeletionStatus> {
    /**
     * Static value Enabled for ResilientVMDeletionStatus.
     */
    public static final ResilientVMDeletionStatus ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for ResilientVMDeletionStatus.
     */
    public static final ResilientVMDeletionStatus DISABLED = fromString("Disabled");

    /**
     * Static value InProgress for ResilientVMDeletionStatus.
     */
    public static final ResilientVMDeletionStatus IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Failed for ResilientVMDeletionStatus.
     */
    public static final ResilientVMDeletionStatus FAILED = fromString("Failed");

    /**
     * Creates a new instance of ResilientVMDeletionStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ResilientVMDeletionStatus() {
    }

    /**
     * Creates or finds a ResilientVMDeletionStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ResilientVMDeletionStatus.
     */
    public static ResilientVMDeletionStatus fromString(String name) {
        return fromString(name, ResilientVMDeletionStatus.class);
    }

    /**
     * Gets known ResilientVMDeletionStatus values.
     * 
     * @return known ResilientVMDeletionStatus values.
     */
    public static Collection<ResilientVMDeletionStatus> values() {
        return values(ResilientVMDeletionStatus.class);
    }
}
