// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes an resiliency policy - AutomaticZoneRebalancingPolicy, ResilientVMCreationPolicy and/or
 * ResilientVMDeletionPolicy.
 */
@Fluent
public final class ResiliencyPolicy implements JsonSerializable<ResiliencyPolicy> {
    /*
     * The configuration parameters used while performing resilient VM creation.
     */
    private ResilientVMCreationPolicy resilientVMCreationPolicy;

    /*
     * The configuration parameters used while performing resilient VM deletion.
     */
    private ResilientVMDeletionPolicy resilientVMDeletionPolicy;

    /*
     * The configuration parameters used while performing automatic AZ balancing.
     */
    private AutomaticZoneRebalancingPolicy automaticZoneRebalancingPolicy;

    /*
     * The configuration parameters used while performing zone allocation.
     */
    private ZoneAllocationPolicy zoneAllocationPolicy;

    /**
     * Creates an instance of ResiliencyPolicy class.
     */
    public ResiliencyPolicy() {
    }

    /**
     * Get the resilientVMCreationPolicy property: The configuration parameters used while performing resilient VM
     * creation.
     * 
     * @return the resilientVMCreationPolicy value.
     */
    public ResilientVMCreationPolicy resilientVMCreationPolicy() {
        return this.resilientVMCreationPolicy;
    }

    /**
     * Set the resilientVMCreationPolicy property: The configuration parameters used while performing resilient VM
     * creation.
     * 
     * @param resilientVMCreationPolicy the resilientVMCreationPolicy value to set.
     * @return the ResiliencyPolicy object itself.
     */
    public ResiliencyPolicy withResilientVMCreationPolicy(ResilientVMCreationPolicy resilientVMCreationPolicy) {
        this.resilientVMCreationPolicy = resilientVMCreationPolicy;
        return this;
    }

    /**
     * Get the resilientVMDeletionPolicy property: The configuration parameters used while performing resilient VM
     * deletion.
     * 
     * @return the resilientVMDeletionPolicy value.
     */
    public ResilientVMDeletionPolicy resilientVMDeletionPolicy() {
        return this.resilientVMDeletionPolicy;
    }

    /**
     * Set the resilientVMDeletionPolicy property: The configuration parameters used while performing resilient VM
     * deletion.
     * 
     * @param resilientVMDeletionPolicy the resilientVMDeletionPolicy value to set.
     * @return the ResiliencyPolicy object itself.
     */
    public ResiliencyPolicy withResilientVMDeletionPolicy(ResilientVMDeletionPolicy resilientVMDeletionPolicy) {
        this.resilientVMDeletionPolicy = resilientVMDeletionPolicy;
        return this;
    }

    /**
     * Get the automaticZoneRebalancingPolicy property: The configuration parameters used while performing automatic AZ
     * balancing.
     * 
     * @return the automaticZoneRebalancingPolicy value.
     */
    public AutomaticZoneRebalancingPolicy automaticZoneRebalancingPolicy() {
        return this.automaticZoneRebalancingPolicy;
    }

    /**
     * Set the automaticZoneRebalancingPolicy property: The configuration parameters used while performing automatic AZ
     * balancing.
     * 
     * @param automaticZoneRebalancingPolicy the automaticZoneRebalancingPolicy value to set.
     * @return the ResiliencyPolicy object itself.
     */
    public ResiliencyPolicy
        withAutomaticZoneRebalancingPolicy(AutomaticZoneRebalancingPolicy automaticZoneRebalancingPolicy) {
        this.automaticZoneRebalancingPolicy = automaticZoneRebalancingPolicy;
        return this;
    }

    /**
     * Get the zoneAllocationPolicy property: The configuration parameters used while performing zone allocation.
     * 
     * @return the zoneAllocationPolicy value.
     */
    public ZoneAllocationPolicy zoneAllocationPolicy() {
        return this.zoneAllocationPolicy;
    }

    /**
     * Set the zoneAllocationPolicy property: The configuration parameters used while performing zone allocation.
     * 
     * @param zoneAllocationPolicy the zoneAllocationPolicy value to set.
     * @return the ResiliencyPolicy object itself.
     */
    public ResiliencyPolicy withZoneAllocationPolicy(ZoneAllocationPolicy zoneAllocationPolicy) {
        this.zoneAllocationPolicy = zoneAllocationPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resilientVMCreationPolicy() != null) {
            resilientVMCreationPolicy().validate();
        }
        if (resilientVMDeletionPolicy() != null) {
            resilientVMDeletionPolicy().validate();
        }
        if (automaticZoneRebalancingPolicy() != null) {
            automaticZoneRebalancingPolicy().validate();
        }
        if (zoneAllocationPolicy() != null) {
            zoneAllocationPolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resilientVMCreationPolicy", this.resilientVMCreationPolicy);
        jsonWriter.writeJsonField("resilientVMDeletionPolicy", this.resilientVMDeletionPolicy);
        jsonWriter.writeJsonField("automaticZoneRebalancingPolicy", this.automaticZoneRebalancingPolicy);
        jsonWriter.writeJsonField("zoneAllocationPolicy", this.zoneAllocationPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResiliencyPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResiliencyPolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResiliencyPolicy.
     */
    public static ResiliencyPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResiliencyPolicy deserializedResiliencyPolicy = new ResiliencyPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resilientVMCreationPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.resilientVMCreationPolicy = ResilientVMCreationPolicy.fromJson(reader);
                } else if ("resilientVMDeletionPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.resilientVMDeletionPolicy = ResilientVMDeletionPolicy.fromJson(reader);
                } else if ("automaticZoneRebalancingPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.automaticZoneRebalancingPolicy
                        = AutomaticZoneRebalancingPolicy.fromJson(reader);
                } else if ("zoneAllocationPolicy".equals(fieldName)) {
                    deserializedResiliencyPolicy.zoneAllocationPolicy = ZoneAllocationPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResiliencyPolicy;
        });
    }
}
