// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is the regional replication status.
 */
@Immutable
public final class RegionalReplicationStatus implements JsonSerializable<RegionalReplicationStatus> {
    /*
     * The region to which the gallery image version is being replicated to.
     */
    private String region;

    /*
     * This is the regional replication state.
     */
    private ReplicationState state;

    /*
     * The details of the replication status.
     */
    private String details;

    /*
     * It indicates progress of the replication job.
     */
    private Integer progress;

    /**
     * Creates an instance of RegionalReplicationStatus class.
     */
    public RegionalReplicationStatus() {
    }

    /**
     * Get the region property: The region to which the gallery image version is being replicated to.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Get the state property: This is the regional replication state.
     * 
     * @return the state value.
     */
    public ReplicationState state() {
        return this.state;
    }

    /**
     * Get the details property: The details of the replication status.
     * 
     * @return the details value.
     */
    public String details() {
        return this.details;
    }

    /**
     * Get the progress property: It indicates progress of the replication job.
     * 
     * @return the progress value.
     */
    public Integer progress() {
        return this.progress;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegionalReplicationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegionalReplicationStatus if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegionalReplicationStatus.
     */
    public static RegionalReplicationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegionalReplicationStatus deserializedRegionalReplicationStatus = new RegionalReplicationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("region".equals(fieldName)) {
                    deserializedRegionalReplicationStatus.region = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedRegionalReplicationStatus.state = ReplicationState.fromString(reader.getString());
                } else if ("details".equals(fieldName)) {
                    deserializedRegionalReplicationStatus.details = reader.getString();
                } else if ("progress".equals(fieldName)) {
                    deserializedRegionalReplicationStatus.progress = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegionalReplicationStatus;
        });
    }
}
