// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration view of an OS version.
 */
@Immutable
public final class OSVersionPropertiesBase implements JsonSerializable<OSVersionPropertiesBase> {
    /*
     * The OS version.
     */
    private String version;

    /*
     * The OS version label.
     */
    private String label;

    /*
     * Specifies whether this is the default OS version for its family.
     */
    private Boolean isDefault;

    /*
     * Specifies whether this OS version is active.
     */
    private Boolean isActive;

    /**
     * Creates an instance of OSVersionPropertiesBase class.
     */
    public OSVersionPropertiesBase() {
    }

    /**
     * Get the version property: The OS version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the label property: The OS version label.
     * 
     * @return the label value.
     */
    public String label() {
        return this.label;
    }

    /**
     * Get the isDefault property: Specifies whether this is the default OS version for its family.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Get the isActive property: Specifies whether this OS version is active.
     * 
     * @return the isActive value.
     */
    public Boolean isActive() {
        return this.isActive;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OSVersionPropertiesBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OSVersionPropertiesBase if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OSVersionPropertiesBase.
     */
    public static OSVersionPropertiesBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OSVersionPropertiesBase deserializedOSVersionPropertiesBase = new OSVersionPropertiesBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedOSVersionPropertiesBase.version = reader.getString();
                } else if ("label".equals(fieldName)) {
                    deserializedOSVersionPropertiesBase.label = reader.getString();
                } else if ("isDefault".equals(fieldName)) {
                    deserializedOSVersionPropertiesBase.isDefault = reader.getNullable(JsonReader::getBoolean);
                } else if ("isActive".equals(fieldName)) {
                    deserializedOSVersionPropertiesBase.isActive = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOSVersionPropertiesBase;
        });
    }
}
