// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. **Note:**
 * The disk encryption set resource id can only be specified for managed disk. Please refer
 * https://aka.ms/mdssewithcmkoverview for more details.
 */
@Fluent
public final class DiskEncryptionSetParameters extends SubResource {
    /**
     * Creates an instance of DiskEncryptionSetParameters class.
     */
    public DiskEncryptionSetParameters() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DiskEncryptionSetParameters withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskEncryptionSetParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskEncryptionSetParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskEncryptionSetParameters.
     */
    public static DiskEncryptionSetParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskEncryptionSetParameters deserializedDiskEncryptionSetParameters = new DiskEncryptionSetParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDiskEncryptionSetParameters.withId(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskEncryptionSetParameters;
        });
    }
}
