// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies if Scheduled Events should be auto-approved when all instances are down.
 */
@Fluent
public final class AllInstancesDown implements JsonSerializable<AllInstancesDown> {
    /*
     * Specifies if Scheduled Events should be auto-approved when all instances are down.
     * its default value is true
     */
    private Boolean automaticallyApprove;

    /**
     * Creates an instance of AllInstancesDown class.
     */
    public AllInstancesDown() {
    }

    /**
     * Get the automaticallyApprove property: Specifies if Scheduled Events should be auto-approved when all instances
     * are down.
     * its default value is true.
     * 
     * @return the automaticallyApprove value.
     */
    public Boolean automaticallyApprove() {
        return this.automaticallyApprove;
    }

    /**
     * Set the automaticallyApprove property: Specifies if Scheduled Events should be auto-approved when all instances
     * are down.
     * its default value is true.
     * 
     * @param automaticallyApprove the automaticallyApprove value to set.
     * @return the AllInstancesDown object itself.
     */
    public AllInstancesDown withAutomaticallyApprove(Boolean automaticallyApprove) {
        this.automaticallyApprove = automaticallyApprove;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("automaticallyApprove", this.automaticallyApprove);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AllInstancesDown from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AllInstancesDown if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AllInstancesDown.
     */
    public static AllInstancesDown fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AllInstancesDown deserializedAllInstancesDown = new AllInstancesDown();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("automaticallyApprove".equals(fieldName)) {
                    deserializedAllInstancesDown.automaticallyApprove = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAllInstancesDown;
        });
    }
}
