// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties of an Access Control Rule RoleAssignment.
 */
@Fluent
public final class AccessControlRulesRoleAssignment implements JsonSerializable<AccessControlRulesRoleAssignment> {
    /*
     * The name of the role.
     */
    private String role;

    /*
     * A list of identities that can access the privileges defined by the role.
     */
    private List<String> identities;

    /**
     * Creates an instance of AccessControlRulesRoleAssignment class.
     */
    public AccessControlRulesRoleAssignment() {
    }

    /**
     * Get the role property: The name of the role.
     * 
     * @return the role value.
     */
    public String role() {
        return this.role;
    }

    /**
     * Set the role property: The name of the role.
     * 
     * @param role the role value to set.
     * @return the AccessControlRulesRoleAssignment object itself.
     */
    public AccessControlRulesRoleAssignment withRole(String role) {
        this.role = role;
        return this;
    }

    /**
     * Get the identities property: A list of identities that can access the privileges defined by the role.
     * 
     * @return the identities value.
     */
    public List<String> identities() {
        return this.identities;
    }

    /**
     * Set the identities property: A list of identities that can access the privileges defined by the role.
     * 
     * @param identities the identities value to set.
     * @return the AccessControlRulesRoleAssignment object itself.
     */
    public AccessControlRulesRoleAssignment withIdentities(List<String> identities) {
        this.identities = identities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (role() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property role in model AccessControlRulesRoleAssignment"));
        }
        if (identities() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property identities in model AccessControlRulesRoleAssignment"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AccessControlRulesRoleAssignment.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role);
        jsonWriter.writeArrayField("identities", this.identities, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessControlRulesRoleAssignment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessControlRulesRoleAssignment if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AccessControlRulesRoleAssignment.
     */
    public static AccessControlRulesRoleAssignment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessControlRulesRoleAssignment deserializedAccessControlRulesRoleAssignment
                = new AccessControlRulesRoleAssignment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("role".equals(fieldName)) {
                    deserializedAccessControlRulesRoleAssignment.role = reader.getString();
                } else if ("identities".equals(fieldName)) {
                    List<String> identities = reader.readArray(reader1 -> reader1.getString());
                    deserializedAccessControlRulesRoleAssignment.identities = identities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessControlRulesRoleAssignment;
        });
    }
}
