// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties of an Access Control Rule Role.
 */
@Fluent
public final class AccessControlRulesRole implements JsonSerializable<AccessControlRulesRole> {
    /*
     * The name of the role.
     */
    private String name;

    /*
     * A list of privileges needed by this role.
     */
    private List<String> privileges;

    /**
     * Creates an instance of AccessControlRulesRole class.
     */
    public AccessControlRulesRole() {
    }

    /**
     * Get the name property: The name of the role.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the role.
     * 
     * @param name the name value to set.
     * @return the AccessControlRulesRole object itself.
     */
    public AccessControlRulesRole withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the privileges property: A list of privileges needed by this role.
     * 
     * @return the privileges value.
     */
    public List<String> privileges() {
        return this.privileges;
    }

    /**
     * Set the privileges property: A list of privileges needed by this role.
     * 
     * @param privileges the privileges value to set.
     * @return the AccessControlRulesRole object itself.
     */
    public AccessControlRulesRole withPrivileges(List<String> privileges) {
        this.privileges = privileges;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model AccessControlRulesRole"));
        }
        if (privileges() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property privileges in model AccessControlRulesRole"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AccessControlRulesRole.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("privileges", this.privileges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessControlRulesRole from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessControlRulesRole if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AccessControlRulesRole.
     */
    public static AccessControlRulesRole fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessControlRulesRole deserializedAccessControlRulesRole = new AccessControlRulesRole();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAccessControlRulesRole.name = reader.getString();
                } else if ("privileges".equals(fieldName)) {
                    List<String> privileges = reader.readArray(reader1 -> reader1.getString());
                    deserializedAccessControlRulesRole.privileges = privileges;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessControlRulesRole;
        });
    }
}
