// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The properties of an Access Control Rule Privilege.
 */
@Fluent
public final class AccessControlRulesPrivilege implements JsonSerializable<AccessControlRulesPrivilege> {
    /*
     * The name of the privilege.
     */
    private String name;

    /*
     * The HTTP path corresponding to the privilege.
     */
    private String path;

    /*
     * The query parameters to match in the path.
     */
    private Map<String, String> queryParameters;

    /**
     * Creates an instance of AccessControlRulesPrivilege class.
     */
    public AccessControlRulesPrivilege() {
    }

    /**
     * Get the name property: The name of the privilege.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the privilege.
     * 
     * @param name the name value to set.
     * @return the AccessControlRulesPrivilege object itself.
     */
    public AccessControlRulesPrivilege withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the path property: The HTTP path corresponding to the privilege.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The HTTP path corresponding to the privilege.
     * 
     * @param path the path value to set.
     * @return the AccessControlRulesPrivilege object itself.
     */
    public AccessControlRulesPrivilege withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the queryParameters property: The query parameters to match in the path.
     * 
     * @return the queryParameters value.
     */
    public Map<String, String> queryParameters() {
        return this.queryParameters;
    }

    /**
     * Set the queryParameters property: The query parameters to match in the path.
     * 
     * @param queryParameters the queryParameters value to set.
     * @return the AccessControlRulesPrivilege object itself.
     */
    public AccessControlRulesPrivilege withQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model AccessControlRulesPrivilege"));
        }
        if (path() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property path in model AccessControlRulesPrivilege"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AccessControlRulesPrivilege.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeMapField("queryParameters", this.queryParameters,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessControlRulesPrivilege from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessControlRulesPrivilege if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AccessControlRulesPrivilege.
     */
    public static AccessControlRulesPrivilege fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessControlRulesPrivilege deserializedAccessControlRulesPrivilege = new AccessControlRulesPrivilege();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAccessControlRulesPrivilege.name = reader.getString();
                } else if ("path".equals(fieldName)) {
                    deserializedAccessControlRulesPrivilege.path = reader.getString();
                } else if ("queryParameters".equals(fieldName)) {
                    Map<String, String> queryParameters = reader.readMap(reader1 -> reader1.getString());
                    deserializedAccessControlRulesPrivilege.queryParameters = queryParameters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessControlRulesPrivilege;
        });
    }
}
