// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of an Access Control Rule Identity.
 */
@Fluent
public final class AccessControlRulesIdentity implements JsonSerializable<AccessControlRulesIdentity> {
    /*
     * The name of the identity.
     */
    private String name;

    /*
     * The username corresponding to this identity.
     */
    private String username;

    /*
     * The groupName corresponding to this identity.
     */
    private String groupName;

    /*
     * The path to the executable.
     */
    private String exePath;

    /*
     * The process name of the executable.
     */
    private String processName;

    /**
     * Creates an instance of AccessControlRulesIdentity class.
     */
    public AccessControlRulesIdentity() {
    }

    /**
     * Get the name property: The name of the identity.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the identity.
     * 
     * @param name the name value to set.
     * @return the AccessControlRulesIdentity object itself.
     */
    public AccessControlRulesIdentity withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the username property: The username corresponding to this identity.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The username corresponding to this identity.
     * 
     * @param username the username value to set.
     * @return the AccessControlRulesIdentity object itself.
     */
    public AccessControlRulesIdentity withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the groupName property: The groupName corresponding to this identity.
     * 
     * @return the groupName value.
     */
    public String groupName() {
        return this.groupName;
    }

    /**
     * Set the groupName property: The groupName corresponding to this identity.
     * 
     * @param groupName the groupName value to set.
     * @return the AccessControlRulesIdentity object itself.
     */
    public AccessControlRulesIdentity withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    /**
     * Get the exePath property: The path to the executable.
     * 
     * @return the exePath value.
     */
    public String exePath() {
        return this.exePath;
    }

    /**
     * Set the exePath property: The path to the executable.
     * 
     * @param exePath the exePath value to set.
     * @return the AccessControlRulesIdentity object itself.
     */
    public AccessControlRulesIdentity withExePath(String exePath) {
        this.exePath = exePath;
        return this;
    }

    /**
     * Get the processName property: The process name of the executable.
     * 
     * @return the processName value.
     */
    public String processName() {
        return this.processName;
    }

    /**
     * Set the processName property: The process name of the executable.
     * 
     * @param processName the processName value to set.
     * @return the AccessControlRulesIdentity object itself.
     */
    public AccessControlRulesIdentity withProcessName(String processName) {
        this.processName = processName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property name in model AccessControlRulesIdentity"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AccessControlRulesIdentity.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("groupName", this.groupName);
        jsonWriter.writeStringField("exePath", this.exePath);
        jsonWriter.writeStringField("processName", this.processName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessControlRulesIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessControlRulesIdentity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AccessControlRulesIdentity.
     */
    public static AccessControlRulesIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessControlRulesIdentity deserializedAccessControlRulesIdentity = new AccessControlRulesIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAccessControlRulesIdentity.name = reader.getString();
                } else if ("userName".equals(fieldName)) {
                    deserializedAccessControlRulesIdentity.username = reader.getString();
                } else if ("groupName".equals(fieldName)) {
                    deserializedAccessControlRulesIdentity.groupName = reader.getString();
                } else if ("exePath".equals(fieldName)) {
                    deserializedAccessControlRulesIdentity.exePath = reader.getString();
                } else if ("processName".equals(fieldName)) {
                    deserializedAccessControlRulesIdentity.processName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessControlRulesIdentity;
        });
    }
}
