// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.fluent.models.VmImagesInEdgeZoneListResultInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import java.util.List;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in VirtualMachineImagesClient.
 */
public final class VirtualMachineImagesClientImpl implements VirtualMachineImagesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final VirtualMachineImagesService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of VirtualMachineImagesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    VirtualMachineImagesClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(VirtualMachineImagesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientVirtualMachineImages to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementClientVirtualMachineImages")
    public interface VirtualMachineImagesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/edgeZones/{edgeZone}/vmimages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VmImagesInEdgeZoneListResultInner>> listByEdgeZone(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @PathParam("edgeZone") String edgeZone,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishers(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<List<VirtualMachineImageResourceInner>>> listOffers(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @PathParam("publisherName") String publisherName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<List<VirtualMachineImageResourceInner>>> listSkus(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @PathParam("publisherName") String publisherName,
            @PathParam("offer") String offer, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<List<VirtualMachineImageResourceInner>>> list(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @PathParam("publisherName") String publisherName,
            @PathParam("offer") String offer, @PathParam("skus") String skus, @QueryParam("$expand") String expand,
            @QueryParam("$top") Integer top, @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions/{version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<VirtualMachineImageInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("location") String location,
            @PathParam("publisherName") String publisherName, @PathParam("offer") String offer,
            @PathParam("skus") String skus, @PathParam("version") String version,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<List<VirtualMachineImageInner>>> listWithProperties(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("location") String location, @PathParam("publisherName") String publisherName,
            @PathParam("offer") String offer, @PathParam("skus") String skus, @QueryParam("$expand") String expand,
            @QueryParam("$top") Integer top, @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets a list of all virtual machine image versions for the specified edge zone.
     * 
     * @param location The name of Azure region.
     * @param edgeZone The name of the edge zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified edge zone along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<VmImagesInEdgeZoneListResultInner>> listByEdgeZoneWithResponseAsync(String location,
        String edgeZone) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByEdgeZone(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), location, edgeZone, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of all virtual machine image versions for the specified edge zone.
     * 
     * @param location The name of Azure region.
     * @param edgeZone The name of the edge zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified edge zone along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<VmImagesInEdgeZoneListResultInner>> listByEdgeZoneWithResponseAsync(String location,
        String edgeZone, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (edgeZone == null) {
            return Mono.error(new IllegalArgumentException("Parameter edgeZone is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByEdgeZone(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), location,
            edgeZone, accept, context);
    }

    /**
     * Gets a list of all virtual machine image versions for the specified edge zone.
     * 
     * @param location The name of Azure region.
     * @param edgeZone The name of the edge zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified edge zone on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VmImagesInEdgeZoneListResultInner> listByEdgeZoneAsync(String location, String edgeZone) {
        return listByEdgeZoneWithResponseAsync(location, edgeZone).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of all virtual machine image versions for the specified edge zone.
     * 
     * @param location The name of Azure region.
     * @param edgeZone The name of the edge zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified edge zone along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<VmImagesInEdgeZoneListResultInner> listByEdgeZoneWithResponse(String location, String edgeZone,
        Context context) {
        return listByEdgeZoneWithResponseAsync(location, edgeZone, context).block();
    }

    /**
     * Gets a list of all virtual machine image versions for the specified edge zone.
     * 
     * @param location The name of Azure region.
     * @param edgeZone The name of the edge zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified edge zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VmImagesInEdgeZoneListResultInner listByEdgeZone(String location, String edgeZone) {
        return listByEdgeZoneWithResponse(location, edgeZone, Context.NONE).getValue();
    }

    /**
     * Gets a list of virtual machine image publishers for the specified Azure location.
     * 
     * @param location The name of Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image publishers for the specified Azure location along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishersWithResponseAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listPublishers(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), location, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of virtual machine image publishers for the specified Azure location.
     * 
     * @param location The name of Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image publishers for the specified Azure location along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishersWithResponseAsync(String location,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listPublishers(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), location,
            accept, context);
    }

    /**
     * Gets a list of virtual machine image publishers for the specified Azure location.
     * 
     * @param location The name of Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image publishers for the specified Azure location on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listPublishersAsync(String location) {
        return listPublishersWithResponseAsync(location).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of virtual machine image publishers for the specified Azure location.
     * 
     * @param location The name of Azure region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image publishers for the specified Azure location along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listPublishersWithResponse(String location,
        Context context) {
        return listPublishersWithResponseAsync(location, context).block();
    }

    /**
     * Gets a list of virtual machine image publishers for the specified Azure location.
     * 
     * @param location The name of Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image publishers for the specified Azure location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listPublishers(String location) {
        return listPublishersWithResponse(location, Context.NONE).getValue();
    }

    /**
     * Gets a list of virtual machine image offers for the specified location and publisher.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image offers for the specified location and publisher along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listOffersWithResponseAsync(String location,
        String publisherName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOffers(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), location, publisherName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of virtual machine image offers for the specified location and publisher.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image offers for the specified location and publisher along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listOffersWithResponseAsync(String location,
        String publisherName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listOffers(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), location,
            publisherName, accept, context);
    }

    /**
     * Gets a list of virtual machine image offers for the specified location and publisher.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image offers for the specified location and publisher on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listOffersAsync(String location, String publisherName) {
        return listOffersWithResponseAsync(location, publisherName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of virtual machine image offers for the specified location and publisher.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image offers for the specified location and publisher along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listOffersWithResponse(String location,
        String publisherName, Context context) {
        return listOffersWithResponseAsync(location, publisherName, context).block();
    }

    /**
     * Gets a list of virtual machine image offers for the specified location and publisher.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image offers for the specified location and publisher.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listOffers(String location, String publisherName) {
        return listOffersWithResponse(location, publisherName, Context.NONE).getValue();
    }

    /**
     * Gets a list of virtual machine image SKUs for the specified location, publisher, and offer.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image SKUs for the specified location, publisher, and offer along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listSkusWithResponseAsync(String location,
        String publisherName, String offer) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSkus(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), location, publisherName, offer, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of virtual machine image SKUs for the specified location, publisher, and offer.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image SKUs for the specified location, publisher, and offer along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listSkusWithResponseAsync(String location,
        String publisherName, String offer, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listSkus(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), location,
            publisherName, offer, accept, context);
    }

    /**
     * Gets a list of virtual machine image SKUs for the specified location, publisher, and offer.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image SKUs for the specified location, publisher, and offer on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listSkusAsync(String location, String publisherName,
        String offer) {
        return listSkusWithResponseAsync(location, publisherName, offer)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of virtual machine image SKUs for the specified location, publisher, and offer.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image SKUs for the specified location, publisher, and offer along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listSkusWithResponse(String location, String publisherName,
        String offer, Context context) {
        return listSkusWithResponseAsync(location, publisherName, offer, context).block();
    }

    /**
     * Gets a list of virtual machine image SKUs for the specified location, publisher, and offer.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of virtual machine image SKUs for the specified location, publisher, and offer.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listSkus(String location, String publisherName, String offer) {
        return listSkusWithResponse(location, publisherName, offer, Context.NONE).getValue();
    }

    /**
     * Gets a list of all virtual machine image versions for the specified location, publisher, offer, and SKU.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @param top The top parameter.
     * @param orderby The orderby parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified location, publisher, offer, and SKU along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listWithResponseAsync(String location,
        String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                location, publisherName, offer, skus, expand, top, orderby, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of all virtual machine image versions for the specified location, publisher, offer, and SKU.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @param top The top parameter.
     * @param orderby The orderby parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified location, publisher, offer, and SKU along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listWithResponseAsync(String location,
        String publisherName, String offer, String skus, String expand, Integer top, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), location,
            publisherName, offer, skus, expand, top, orderby, accept, context);
    }

    /**
     * Gets a list of all virtual machine image versions for the specified location, publisher, offer, and SKU.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified location, publisher, offer, and SKU on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listAsync(String location, String publisherName, String offer,
        String skus) {
        final String expand = null;
        final Integer top = null;
        final String orderby = null;
        return listWithResponseAsync(location, publisherName, offer, skus, expand, top, orderby)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of all virtual machine image versions for the specified location, publisher, offer, and SKU.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @param top The top parameter.
     * @param orderby The orderby parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified location, publisher, offer, and SKU along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listWithResponse(String location, String publisherName,
        String offer, String skus, String expand, Integer top, String orderby, Context context) {
        return listWithResponseAsync(location, publisherName, offer, skus, expand, top, orderby, context).block();
    }

    /**
     * Gets a list of all virtual machine image versions for the specified location, publisher, offer, and SKU.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all virtual machine image versions for the specified location, publisher, offer, and SKU.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> list(String location, String publisherName, String offer,
        String skus) {
        final String expand = null;
        final Integer top = null;
        final String orderby = null;
        return listWithResponse(location, publisherName, offer, skus, expand, top, orderby, Context.NONE).getValue();
    }

    /**
     * Gets a virtual machine image.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param version A valid image SKU version.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a virtual machine image along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<VirtualMachineImageInner>> getWithResponseAsync(String location, String publisherName,
        String offer, String skus, String version) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error(new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, location, publisherName, offer,
                skus, version, this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a virtual machine image.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param version A valid image SKU version.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a virtual machine image along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<VirtualMachineImageInner>> getWithResponseAsync(String location, String publisherName,
        String offer, String skus, String version, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error(new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, location, publisherName, offer, skus, version,
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Gets a virtual machine image.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param version A valid image SKU version.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a virtual machine image on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VirtualMachineImageInner> getAsync(String location, String publisherName, String offer, String skus,
        String version) {
        return getWithResponseAsync(location, publisherName, offer, skus, version)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a virtual machine image.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param version A valid image SKU version.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a virtual machine image along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<VirtualMachineImageInner> getWithResponse(String location, String publisherName, String offer,
        String skus, String version, Context context) {
        return getWithResponseAsync(location, publisherName, offer, skus, version, context).block();
    }

    /**
     * Gets a virtual machine image.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param version A valid image SKU version.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a virtual machine image.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VirtualMachineImageInner get(String location, String publisherName, String offer, String skus,
        String version) {
        return getWithResponse(location, publisherName, offer, skus, version, Context.NONE).getValue();
    }

    /**
     * The listWithProperties operation.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @param top The top parameter.
     * @param orderby The orderby parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VirtualMachineImage along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageInner>>> listWithPropertiesWithResponseAsync(String location,
        String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (expand == null) {
            return Mono.error(new IllegalArgumentException("Parameter expand is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listWithProperties(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), location, publisherName, offer, skus, expand, top, orderby, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The listWithProperties operation.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @param top The top parameter.
     * @param orderby The orderby parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VirtualMachineImage along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageInner>>> listWithPropertiesWithResponseAsync(String location,
        String publisherName, String offer, String skus, String expand, Integer top, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error(new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error(new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error(new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (expand == null) {
            return Mono.error(new IllegalArgumentException("Parameter expand is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listWithProperties(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            location, publisherName, offer, skus, expand, top, orderby, accept, context);
    }

    /**
     * The listWithProperties operation.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VirtualMachineImage on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageInner>> listWithPropertiesAsync(String location, String publisherName,
        String offer, String skus, String expand) {
        final Integer top = null;
        final String orderby = null;
        return listWithPropertiesWithResponseAsync(location, publisherName, offer, skus, expand, top, orderby)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The listWithProperties operation.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @param top The top parameter.
     * @param orderby The orderby parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VirtualMachineImage along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<VirtualMachineImageInner>> listWithPropertiesWithResponse(String location,
        String publisherName, String offer, String skus, String expand, Integer top, String orderby, Context context) {
        return listWithPropertiesWithResponseAsync(location, publisherName, offer, skus, expand, top, orderby, context)
            .block();
    }

    /**
     * The listWithProperties operation.
     * 
     * @param location The name of Azure region.
     * @param publisherName A valid image publisher.
     * @param offer A valid image publisher offer.
     * @param skus A valid image SKU.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VirtualMachineImage.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<VirtualMachineImageInner> listWithProperties(String location, String publisherName, String offer,
        String skus, String expand) {
        final Integer top = null;
        final String orderby = null;
        return listWithPropertiesWithResponse(location, publisherName, offer, skus, expand, top, orderby, Context.NONE)
            .getValue();
    }
}
