// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Specifies information about the gallery inVMAccessControlProfile that you want to create or update.
 */
@Fluent
public final class GalleryInVMAccessControlProfileInner extends Resource {
    /*
     * Describes the properties of a gallery inVMAccessControlProfile.
     */
    private GalleryInVMAccessControlProfileProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GalleryInVMAccessControlProfileInner class.
     */
    public GalleryInVMAccessControlProfileInner() {
    }

    /**
     * Get the properties property: Describes the properties of a gallery inVMAccessControlProfile.
     * 
     * @return the properties value.
     */
    public GalleryInVMAccessControlProfileProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Describes the properties of a gallery inVMAccessControlProfile.
     * 
     * @param properties the properties value to set.
     * @return the GalleryInVMAccessControlProfileInner object itself.
     */
    public GalleryInVMAccessControlProfileInner withProperties(GalleryInVMAccessControlProfileProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInVMAccessControlProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInVMAccessControlProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInVMAccessControlProfileInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInVMAccessControlProfileInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryInVMAccessControlProfileInner.
     */
    public static GalleryInVMAccessControlProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileInner deserializedGalleryInVMAccessControlProfileInner
                = new GalleryInVMAccessControlProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryInVMAccessControlProfileInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileInner.properties
                        = GalleryInVMAccessControlProfileProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInVMAccessControlProfileInner;
        });
    }
}
