// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import java.io.IOException;

/**
 * Describes the properties of a gallery image version.
 */
@Fluent
public final class GalleryApplicationVersionProperties
    implements JsonSerializable<GalleryApplicationVersionProperties> {
    /*
     * The publishing profile of a gallery image version.
     */
    private GalleryApplicationVersionPublishingProfile publishingProfile;

    /*
     * The safety profile of the Gallery Application Version.
     */
    private GalleryApplicationVersionSafetyProfile safetyProfile;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /*
     * This is the replication status of the gallery image version.
     */
    private ReplicationStatus replicationStatus;

    /**
     * Creates an instance of GalleryApplicationVersionProperties class.
     */
    public GalleryApplicationVersionProperties() {
    }

    /**
     * Get the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @return the publishingProfile value.
     */
    public GalleryApplicationVersionPublishingProfile publishingProfile() {
        return this.publishingProfile;
    }

    /**
     * Set the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @param publishingProfile the publishingProfile value to set.
     * @return the GalleryApplicationVersionProperties object itself.
     */
    public GalleryApplicationVersionProperties
        withPublishingProfile(GalleryApplicationVersionPublishingProfile publishingProfile) {
        this.publishingProfile = publishingProfile;
        return this;
    }

    /**
     * Get the safetyProfile property: The safety profile of the Gallery Application Version.
     * 
     * @return the safetyProfile value.
     */
    public GalleryApplicationVersionSafetyProfile safetyProfile() {
        return this.safetyProfile;
    }

    /**
     * Set the safetyProfile property: The safety profile of the Gallery Application Version.
     * 
     * @param safetyProfile the safetyProfile value to set.
     * @return the GalleryApplicationVersionProperties object itself.
     */
    public GalleryApplicationVersionProperties withSafetyProfile(GalleryApplicationVersionSafetyProfile safetyProfile) {
        this.safetyProfile = safetyProfile;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publishingProfile() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property publishingProfile in model GalleryApplicationVersionProperties"));
        } else {
            publishingProfile().validate();
        }
        if (safetyProfile() != null) {
            safetyProfile().validate();
        }
        if (replicationStatus() != null) {
            replicationStatus().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationVersionProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("publishingProfile", this.publishingProfile);
        jsonWriter.writeJsonField("safetyProfile", this.safetyProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryApplicationVersionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryApplicationVersionProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryApplicationVersionProperties.
     */
    public static GalleryApplicationVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryApplicationVersionProperties deserializedGalleryApplicationVersionProperties
                = new GalleryApplicationVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publishingProfile".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.publishingProfile
                        = GalleryApplicationVersionPublishingProfile.fromJson(reader);
                } else if ("safetyProfile".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.safetyProfile
                        = GalleryApplicationVersionSafetyProfile.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.replicationStatus
                        = ReplicationStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryApplicationVersionProperties;
        });
    }
}
