// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.ScheduledEventsPolicy;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetMigrationInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines
 * specified in the same availability set are allocated to different nodes to maximize availability. For more
 * information about availability sets, see [Availability sets
 * overview](https://docs.microsoft.com/azure/virtual-machines/availability-set-overview). For more information on Azure
 * planned maintenance, see [Maintenance and updates for Virtual Machines in
 * Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added
 * to an availability set at creation time. An existing VM cannot be added to an availability set.
 */
@Fluent
public final class AvailabilitySetInner extends Resource {
    /*
     * The instance view of a resource.
     */
    private AvailabilitySetProperties innerProperties;

    /*
     * Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of
     * values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged
     * disks. Default value is 'Classic'.
     */
    private Sku sku;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AvailabilitySetInner class.
     */
    public AvailabilitySetInner() {
    }

    /**
     * Get the innerProperties property: The instance view of a resource.
     * 
     * @return the innerProperties value.
     */
    private AvailabilitySetProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the sku property: Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes
     * for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual
     * machines with unmanaged disks. Default value is 'Classic'.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes
     * for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual
     * machines with unmanaged disks. Default value is 'Classic'.
     * 
     * @param sku the sku value to set.
     * @return the AvailabilitySetInner object itself.
     */
    public AvailabilitySetInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AvailabilitySetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AvailabilitySetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the platformUpdateDomainCount property: Update Domain count.
     * 
     * @return the platformUpdateDomainCount value.
     */
    public Integer platformUpdateDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformUpdateDomainCount();
    }

    /**
     * Set the platformUpdateDomainCount property: Update Domain count.
     * 
     * @param platformUpdateDomainCount the platformUpdateDomainCount value to set.
     * @return the AvailabilitySetInner object itself.
     */
    public AvailabilitySetInner withPlatformUpdateDomainCount(Integer platformUpdateDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withPlatformUpdateDomainCount(platformUpdateDomainCount);
        return this;
    }

    /**
     * Get the platformFaultDomainCount property: Fault Domain count.
     * 
     * @return the platformFaultDomainCount value.
     */
    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomainCount();
    }

    /**
     * Set the platformFaultDomainCount property: Fault Domain count.
     * 
     * @param platformFaultDomainCount the platformFaultDomainCount value to set.
     * @return the AvailabilitySetInner object itself.
     */
    public AvailabilitySetInner withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withPlatformFaultDomainCount(platformFaultDomainCount);
        return this;
    }

    /**
     * Get the virtualMachines property: A list of references to all virtual machines in the availability set.
     * 
     * @return the virtualMachines value.
     */
    public List<SubResource> virtualMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachines();
    }

    /**
     * Set the virtualMachines property: A list of references to all virtual machines in the availability set.
     * 
     * @param virtualMachines the virtualMachines value to set.
     * @return the AvailabilitySetInner object itself.
     */
    public AvailabilitySetInner withVirtualMachines(List<SubResource> virtualMachines) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withVirtualMachines(virtualMachines);
        return this;
    }

    /**
     * Get the proximityPlacementGroup property: Specifies information about the proximity placement group that the
     * availability set should be assigned to. Minimum api-version: 2018-04-01.
     * 
     * @return the proximityPlacementGroup value.
     */
    public SubResource proximityPlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroup();
    }

    /**
     * Set the proximityPlacementGroup property: Specifies information about the proximity placement group that the
     * availability set should be assigned to. Minimum api-version: 2018-04-01.
     * 
     * @param proximityPlacementGroup the proximityPlacementGroup value to set.
     * @return the AvailabilitySetInner object itself.
     */
    public AvailabilitySetInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    /**
     * Get the statuses property: The resource status information.
     * 
     * @return the statuses value.
     */
    public List<InstanceViewStatus> statuses() {
        return this.innerProperties() == null ? null : this.innerProperties().statuses();
    }

    /**
     * Get the scheduledEventsPolicy property: Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets
     * Scheduled Event related configurations for the availability set.
     * 
     * @return the scheduledEventsPolicy value.
     */
    public ScheduledEventsPolicy scheduledEventsPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduledEventsPolicy();
    }

    /**
     * Set the scheduledEventsPolicy property: Specifies Redeploy, Reboot and ScheduledEventsAdditionalPublishingTargets
     * Scheduled Event related configurations for the availability set.
     * 
     * @param scheduledEventsPolicy the scheduledEventsPolicy value to set.
     * @return the AvailabilitySetInner object itself.
     */
    public AvailabilitySetInner withScheduledEventsPolicy(ScheduledEventsPolicy scheduledEventsPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withScheduledEventsPolicy(scheduledEventsPolicy);
        return this;
    }

    /**
     * Get the virtualMachineScaleSetMigrationInfo property: Describes the migration properties on the Availability Set.
     * 
     * @return the virtualMachineScaleSetMigrationInfo value.
     */
    public VirtualMachineScaleSetMigrationInfo virtualMachineScaleSetMigrationInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachineScaleSetMigrationInfo();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailabilitySetInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailabilitySetInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AvailabilitySetInner.
     */
    public static AvailabilitySetInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailabilitySetInner deserializedAvailabilitySetInner = new AvailabilitySetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAvailabilitySetInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAvailabilitySetInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAvailabilitySetInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedAvailabilitySetInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAvailabilitySetInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedAvailabilitySetInner.innerProperties = AvailabilitySetProperties.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedAvailabilitySetInner.sku = Sku.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedAvailabilitySetInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailabilitySetInner;
        });
    }
}
