/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import java.io.IOException;

public final class GalleryApplicationVersionProperties
implements JsonSerializable<GalleryApplicationVersionProperties> {
    private GalleryApplicationVersionPublishingProfile publishingProfile;
    private GalleryApplicationVersionSafetyProfile safetyProfile;
    private GalleryProvisioningState provisioningState;
    private ReplicationStatus replicationStatus;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationVersionProperties.class);

    public GalleryApplicationVersionPublishingProfile publishingProfile() {
        return this.publishingProfile;
    }

    public GalleryApplicationVersionProperties withPublishingProfile(GalleryApplicationVersionPublishingProfile publishingProfile) {
        this.publishingProfile = publishingProfile;
        return this;
    }

    public GalleryApplicationVersionSafetyProfile safetyProfile() {
        return this.safetyProfile;
    }

    public GalleryApplicationVersionProperties withSafetyProfile(GalleryApplicationVersionSafetyProfile safetyProfile) {
        this.safetyProfile = safetyProfile;
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    public void validate() {
        if (this.publishingProfile() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publishingProfile in model GalleryApplicationVersionProperties"));
        }
        this.publishingProfile().validate();
        if (this.safetyProfile() != null) {
            this.safetyProfile().validate();
        }
        if (this.replicationStatus() != null) {
            this.replicationStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("publishingProfile", (JsonSerializable)this.publishingProfile);
        jsonWriter.writeJsonField("safetyProfile", (JsonSerializable)this.safetyProfile);
        return jsonWriter.writeEndObject();
    }

    public static GalleryApplicationVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryApplicationVersionProperties)jsonReader.readObject(reader -> {
            GalleryApplicationVersionProperties deserializedGalleryApplicationVersionProperties = new GalleryApplicationVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publishingProfile".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.publishingProfile = GalleryApplicationVersionPublishingProfile.fromJson(reader);
                    continue;
                }
                if ("safetyProfile".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.safetyProfile = GalleryApplicationVersionSafetyProfile.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.provisioningState = GalleryProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryApplicationVersionProperties.replicationStatus = ReplicationStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryApplicationVersionProperties;
        });
    }
}

