/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DiskPurchasePlan
implements JsonSerializable<DiskPurchasePlan> {
    private String name;
    private String publisher;
    private String product;
    private String promotionCode;
    private static final ClientLogger LOGGER = new ClientLogger(DiskPurchasePlan.class);

    public String name() {
        return this.name;
    }

    public DiskPurchasePlan withName(String name) {
        this.name = name;
        return this;
    }

    public String publisher() {
        return this.publisher;
    }

    public DiskPurchasePlan withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public String product() {
        return this.product;
    }

    public DiskPurchasePlan withProduct(String product) {
        this.product = product;
        return this;
    }

    public String promotionCode() {
        return this.promotionCode;
    }

    public DiskPurchasePlan withPromotionCode(String promotionCode) {
        this.promotionCode = promotionCode;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DiskPurchasePlan"));
        }
        if (this.publisher() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publisher in model DiskPurchasePlan"));
        }
        if (this.product() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property product in model DiskPurchasePlan"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("product", this.product);
        jsonWriter.writeStringField("promotionCode", this.promotionCode);
        return jsonWriter.writeEndObject();
    }

    public static DiskPurchasePlan fromJson(JsonReader jsonReader) throws IOException {
        return (DiskPurchasePlan)jsonReader.readObject(reader -> {
            DiskPurchasePlan deserializedDiskPurchasePlan = new DiskPurchasePlan();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDiskPurchasePlan.name = reader.getString();
                    continue;
                }
                if ("publisher".equals(fieldName)) {
                    deserializedDiskPurchasePlan.publisher = reader.getString();
                    continue;
                }
                if ("product".equals(fieldName)) {
                    deserializedDiskPurchasePlan.product = reader.getString();
                    continue;
                }
                if ("promotionCode".equals(fieldName)) {
                    deserializedDiskPurchasePlan.promotionCode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskPurchasePlan;
        });
    }
}

