/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceVaultCertificate;
import java.io.IOException;
import java.util.List;

public final class CloudServiceVaultSecretGroup
implements JsonSerializable<CloudServiceVaultSecretGroup> {
    private SubResource sourceVault;
    private List<CloudServiceVaultCertificate> vaultCertificates;

    public SubResource sourceVault() {
        return this.sourceVault;
    }

    public CloudServiceVaultSecretGroup withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public List<CloudServiceVaultCertificate> vaultCertificates() {
        return this.vaultCertificates;
    }

    public CloudServiceVaultSecretGroup withVaultCertificates(List<CloudServiceVaultCertificate> vaultCertificates) {
        this.vaultCertificates = vaultCertificates;
        return this;
    }

    public void validate() {
        if (this.vaultCertificates() != null) {
            this.vaultCertificates().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceVault", (JsonSerializable)this.sourceVault);
        jsonWriter.writeArrayField("vaultCertificates", this.vaultCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceVaultSecretGroup fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceVaultSecretGroup)jsonReader.readObject(reader -> {
            CloudServiceVaultSecretGroup deserializedCloudServiceVaultSecretGroup = new CloudServiceVaultSecretGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceVault".equals(fieldName)) {
                    deserializedCloudServiceVaultSecretGroup.sourceVault = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("vaultCertificates".equals(fieldName)) {
                    List vaultCertificates;
                    deserializedCloudServiceVaultSecretGroup.vaultCertificates = vaultCertificates = reader.readArray(reader1 -> CloudServiceVaultCertificate.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceVaultSecretGroup;
        });
    }
}

