/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliaryMode;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliarySku;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIpConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetNetworkConfigurationProperties
implements JsonSerializable<VirtualMachineScaleSetNetworkConfigurationProperties> {
    private Boolean primary;
    private Boolean enableAcceleratedNetworking;
    private Boolean disableTcpStateTracking;
    private Boolean enableFpga;
    private SubResource networkSecurityGroup;
    private VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings;
    private List<VirtualMachineScaleSetIpConfiguration> ipConfigurations;
    private Boolean enableIpForwarding;
    private DeleteOptions deleteOption;
    private NetworkInterfaceAuxiliaryMode auxiliaryMode;
    private NetworkInterfaceAuxiliarySku auxiliarySku;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetNetworkConfigurationProperties.class);

    public Boolean primary() {
        return this.primary;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public Boolean disableTcpStateTracking() {
        return this.disableTcpStateTracking;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withDisableTcpStateTracking(Boolean disableTcpStateTracking) {
        this.disableTcpStateTracking = disableTcpStateTracking;
        return this;
    }

    public Boolean enableFpga() {
        return this.enableFpga;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withEnableFpga(Boolean enableFpga) {
        this.enableFpga = enableFpga;
        return this;
    }

    public SubResource networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withNetworkSecurityGroup(SubResource networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withDnsSettings(VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineScaleSetIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withIpConfigurations(List<VirtualMachineScaleSetIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.enableIpForwarding;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withEnableIpForwarding(Boolean enableIpForwarding) {
        this.enableIpForwarding = enableIpForwarding;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public NetworkInterfaceAuxiliaryMode auxiliaryMode() {
        return this.auxiliaryMode;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withAuxiliaryMode(NetworkInterfaceAuxiliaryMode auxiliaryMode) {
        this.auxiliaryMode = auxiliaryMode;
        return this;
    }

    public NetworkInterfaceAuxiliarySku auxiliarySku() {
        return this.auxiliarySku;
    }

    public VirtualMachineScaleSetNetworkConfigurationProperties withAuxiliarySku(NetworkInterfaceAuxiliarySku auxiliarySku) {
        this.auxiliarySku = auxiliarySku;
        return this;
    }

    public void validate() {
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ipConfigurations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipConfigurations in model VirtualMachineScaleSetNetworkConfigurationProperties"));
        }
        this.ipConfigurations().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("primary", this.primary);
        jsonWriter.writeBooleanField("enableAcceleratedNetworking", this.enableAcceleratedNetworking);
        jsonWriter.writeBooleanField("disableTcpStateTracking", this.disableTcpStateTracking);
        jsonWriter.writeBooleanField("enableFpga", this.enableFpga);
        jsonWriter.writeJsonField("networkSecurityGroup", (JsonSerializable)this.networkSecurityGroup);
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeBooleanField("enableIPForwarding", this.enableIpForwarding);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        jsonWriter.writeStringField("auxiliaryMode", this.auxiliaryMode == null ? null : this.auxiliaryMode.toString());
        jsonWriter.writeStringField("auxiliarySku", this.auxiliarySku == null ? null : this.auxiliarySku.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetNetworkConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetNetworkConfigurationProperties)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetNetworkConfigurationProperties deserializedVirtualMachineScaleSetNetworkConfigurationProperties = new VirtualMachineScaleSetNetworkConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> VirtualMachineScaleSetIpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("primary".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.primary = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAcceleratedNetworking".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.enableAcceleratedNetworking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableTcpStateTracking".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.disableTcpStateTracking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableFpga".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.enableFpga = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.networkSecurityGroup = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.dnsSettings = VirtualMachineScaleSetNetworkConfigurationDnsSettings.fromJson(reader);
                    continue;
                }
                if ("enableIPForwarding".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.enableIpForwarding = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.deleteOption = DeleteOptions.fromString(reader.getString());
                    continue;
                }
                if ("auxiliaryMode".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.auxiliaryMode = NetworkInterfaceAuxiliaryMode.fromString(reader.getString());
                    continue;
                }
                if ("auxiliarySku".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkConfigurationProperties.auxiliarySku = NetworkInterfaceAuxiliarySku.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetNetworkConfigurationProperties;
        });
    }
}

