/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AlternativeOption;
import com.azure.resourcemanager.compute.models.ImageState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ImageDeprecationStatus
implements JsonSerializable<ImageDeprecationStatus> {
    private ImageState imageState;
    private OffsetDateTime scheduledDeprecationTime;
    private AlternativeOption alternativeOption;

    public ImageState imageState() {
        return this.imageState;
    }

    public ImageDeprecationStatus withImageState(ImageState imageState) {
        this.imageState = imageState;
        return this;
    }

    public OffsetDateTime scheduledDeprecationTime() {
        return this.scheduledDeprecationTime;
    }

    public ImageDeprecationStatus withScheduledDeprecationTime(OffsetDateTime scheduledDeprecationTime) {
        this.scheduledDeprecationTime = scheduledDeprecationTime;
        return this;
    }

    public AlternativeOption alternativeOption() {
        return this.alternativeOption;
    }

    public ImageDeprecationStatus withAlternativeOption(AlternativeOption alternativeOption) {
        this.alternativeOption = alternativeOption;
        return this;
    }

    public void validate() {
        if (this.alternativeOption() != null) {
            this.alternativeOption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("imageState", this.imageState == null ? null : this.imageState.toString());
        jsonWriter.writeStringField("scheduledDeprecationTime", this.scheduledDeprecationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledDeprecationTime));
        jsonWriter.writeJsonField("alternativeOption", (JsonSerializable)this.alternativeOption);
        return jsonWriter.writeEndObject();
    }

    public static ImageDeprecationStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ImageDeprecationStatus)jsonReader.readObject(reader -> {
            ImageDeprecationStatus deserializedImageDeprecationStatus = new ImageDeprecationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageState".equals(fieldName)) {
                    deserializedImageDeprecationStatus.imageState = ImageState.fromString(reader.getString());
                    continue;
                }
                if ("scheduledDeprecationTime".equals(fieldName)) {
                    deserializedImageDeprecationStatus.scheduledDeprecationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("alternativeOption".equals(fieldName)) {
                    deserializedImageDeprecationStatus.alternativeOption = AlternativeOption.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageDeprecationStatus;
        });
    }
}

