/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryIdentifier;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryProperties;
import com.azure.resourcemanager.compute.models.CommunityGalleryMetadata;
import com.azure.resourcemanager.compute.models.PirCommunityGalleryResource;
import java.io.IOException;
import java.util.Map;

public final class CommunityGalleryInner
extends PirCommunityGalleryResource {
    private CommunityGalleryProperties innerProperties;
    private CommunityGalleryIdentifier innerIdentifier;
    private String type;
    private String location;
    private String name;

    private CommunityGalleryProperties innerProperties() {
        return this.innerProperties;
    }

    private CommunityGalleryIdentifier innerIdentifier() {
        return this.innerIdentifier;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String uniqueId() {
        return this.innerIdentifier() == null ? null : this.innerIdentifier().uniqueId();
    }

    @Override
    public CommunityGalleryInner withUniqueId(String uniqueId) {
        if (this.innerIdentifier() == null) {
            this.innerIdentifier = new CommunityGalleryIdentifier();
        }
        this.innerIdentifier().withUniqueId(uniqueId);
        return this;
    }

    public String disclaimer() {
        return this.innerProperties() == null ? null : this.innerProperties().disclaimer();
    }

    public CommunityGalleryInner withDisclaimer(String disclaimer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryProperties();
        }
        this.innerProperties().withDisclaimer(disclaimer);
        return this;
    }

    public Map<String, String> artifactTags() {
        return this.innerProperties() == null ? null : this.innerProperties().artifactTags();
    }

    public CommunityGalleryInner withArtifactTags(Map<String, String> artifactTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryProperties();
        }
        this.innerProperties().withArtifactTags(artifactTags);
        return this;
    }

    public CommunityGalleryMetadata communityMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().communityMetadata();
    }

    public CommunityGalleryInner withCommunityMetadata(CommunityGalleryMetadata communityMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CommunityGalleryProperties();
        }
        this.innerProperties().withCommunityMetadata(communityMetadata);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.innerIdentifier() != null) {
            this.innerIdentifier().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.innerIdentifier());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CommunityGalleryInner fromJson(JsonReader jsonReader) throws IOException {
        return (CommunityGalleryInner)jsonReader.readObject(reader -> {
            CommunityGalleryInner deserializedCommunityGalleryInner = new CommunityGalleryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCommunityGalleryInner.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCommunityGalleryInner.location = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCommunityGalleryInner.type = reader.getString();
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedCommunityGalleryInner.innerIdentifier = CommunityGalleryIdentifier.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCommunityGalleryInner.innerProperties = CommunityGalleryProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommunityGalleryInner;
        });
    }
}

